#!/bin/bash
# 修复安装部署规划文件的空数据
LOG_FILE=/opt/install/deal_empty_nodes.sh.log
installDir=$1
cryptDir=$installDir/crypt

# 记录操作日志
function LOG()
{
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
        echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${SELF_FILE}] ${Level} | $2" 1>&2
        echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${SELF_FILE}] ${Level} | $2" >> "${LOG_FILE}"
        logger -p local0.error "[${SELF_FILE}] ${Level} | $2"
    else
        Level="INFO"
        echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${SELF_FILE}] ${Level} | $2" | tee -a "${LOG_FILE}"
        logger -p local0.info "[${SELF_FILE}] ${Level} | $2"
    fi
}

# 调python文件处理规划数据中的空数据
Main()
{
    # deal empty nodes
    if [ -f "/opt/install/deal_empty_nodes.pyc" ]
    then
        PYTHON_FILE=deal_empty_nodes.pyc
    else
        if [ -f "/opt/install/deal_empty_nodes.py" ]
        then
            PYTHON_FILE=deal_empty_nodes.py
        else
            LOG  "ERROR"  "Can not find replace_input file"
            return 1
        fi
    fi
    ${cryptDir}/python/bin/python /opt/install/${PYTHON_FILE} $2
    if [ $? -eq 0 ]
    then
        LOG  "INFO"  "deal empty nodes for network.json and input.json success."
    else
        LOG  "Warning"  "deal empty nodes for network.json and input.json exception, please confirm it manually."
        return 1
    fi
}

Main $*
exit $?
