#!/bin/bash
. /etc/profile
MODULE_NAME="$(basename $0)"
#install dir
installDir=/opt/install
# 高斯V1R3驱动包
GAUSS_PKG=".*GaussDriver_linux_.*64.zip"
getPackageName()
{
    #icmr sofrware package
    OSMediation="iMasterNCE.*\OSMediation_linux-.*64.zip"
    #uniep package
    uniep="iMasterNCE.*\OMP_linux-.*64"
    #EasySuite package
    EasySuitePackage="iMasterNCE.*\EasySuite"
    #nce package
    ncePackage="iMasterNCE.*"
    if [ "$#" == "2" -a "$1" == "-productname" ]
    then
        productname=$2
        OSMediation=".*${productname}.*\OSMediation_linux-.*64.zip"
        uniep=".*${productname}.*\OMP_linux-.*64"
        EasySuitePackage=".*${productname}.*\EasySuite"
        ncePackage=".*${productname}.*"
    fi
}


#####################################
#2018.2.13规避平台问题
#当前提供规避方案：检测IO占用小于85%的时候，再执行扫描包的任务，保证任务执行成功
#超时2min退出
#####################################
waitIOHealth()
{
     for ((i=0; i<12; i++))
    do
        [ ! -f iostat ] && { return 0; }
        #wait all io util < 85
        isok=`iostat -d -x 1 2 | sed -n '/Device:/,$p' | sed '/Device:/d' | sed '/^$/d'  | awk '{print $NF}'  | awk '{print $NF}'  | awk 'BEGIN {isok = 0}
        {
            for (j = 1; j <= NF; ++j) {
                if ($j > 85) isok = 1
            }
        }
        END {print isok}'`
        [ "$isok" == 0 ] && { echo "io stat is ok"; return 0; }
        echo "io util is more than 85%, sleep 10 seconds..."
        sleep 10
    done
    
    echo "io util is more than 85%, scaning packages may be failed"
    return 1    
}

createCheckFile()
{
    echo "#!/bin/bash" >/opt/install/check_scan_result.sh
    echo "echo  RESULT:1" >>/opt/install/check_scan_result.sh
    chmod 750 /opt/install/check_scan_result.sh
}

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

logFile="${curPath}/${MODULE_NAME}.log"

#log
OperateLog()
{
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 640 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi

    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    if [ -z "${Level}" ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /opt/install/check_scan_result.sh
   ">/opt/install/check_scan_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /opt/install/check_scan_result.sh
   ">/opt/install/check_scan_result.sh
   fi
   chmod 750 /opt/install/check_scan_result.sh > /dev/null 2>&1
   return $1
}

#install product
Install()
{ 
    chmod -R 750 $installDir > /dev/null 2>&1
    #先清除旧的
    rm -rf /opt/oss/manager/var/tmp/*
    rm -rf /opt/pub/software/services/*
    #拷贝产品包
    local nce_package_list=$(ls "${installDir}" | grep "^${ncePackage}" | egrep -v "grep|${GAUSS_PKG}|${uniep}|${OSMediation}|${EasySuitePackage}")
    if [ "${nce_package_list}" != "" ]
    then
        for package in ${nce_package_list}
        do
        {
            cp -rf $installDir/${package} /opt/oss/manager/var/tmp
            if [ $? -ne 0 ]
            then
                OperateLog "error" "Error: copy $installDir/${package} to /opt/oss/manager/var/tmp failed. please check the available space of the disk"
                return 1
            fi
        }
        done
    fi
    
    #####################################
    #2018.2.13规避平台问题
    #当前提供规避方案：检测IO占用小于85%的时候，再执行扫描包的任务，保证任务执行成功
    #####################################
    waitIOHealth || return 1

    #scan silent
    cd /opt/oss/manager/tools/deployapp && bash scanpackage.sh
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: scan silent: execute the scanpackage.sh script failed."
        OperateLog "error" "please login OMP(management platform), check detail error messages and follow suggestions in the execution logs."
        return 1
    fi
    
    return 0
}

Main()
{
    getPackageName $*
    createCheckFile
    #install
    Install
    if [ $? -ne 0 ]
    then
        OperateLog "error" "Error: Install product: the scan_packages.sh script execute failed."
        return 1
    fi
    
   return 0
}

id | grep "ossadm" &>/dev/null
if [ $? -eq 0 ]
then
    Main $*
    getcheckResult $?
    exit $?
else
    chmod -R 750 ${curPath}
    chown -R ossadm:ossgroup ${curPath}
    su - ossadm -c "cd ${curPath} && bash ${MODULE_NAME} $*"
fi