#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: set_password_expiration.sh
# Description: NCE操作系统用户密码过期时间配置
##############################################################################

SELF_FILE=$(basename $0)
USER_LIST="root ossadm ossuser ftpuser dbuser iscript secuser"

############################################################
# Description: 打印日志
############################################################
function LOG() {
    level=${1}
    message=${2}
    echo "[$(date +"%Y-%m-%d %H:%M:%S")] [${SELF_FILE}] [${level}] | ${message}"
}

function main() {
    LOG "INFO" "Set the user password validity period configuration."
    chage -M 99999 omm >/dev/null 2>&1
    chage -M 99999 ommdba >/dev/null 2>&1
    for username in ${USER_LIST}; do
        id ${username} >/dev/null 2>&1
        if [ $? -eq 0 ];then
            # 修改密码不过期
            chage --maxdays 99999 ${username}
            # 修改密码修改最小间隔时间7天
            chage --mindays 7 ${username}
            # 修改密码过期前7天提醒
            chage --warndays 7 ${username}
            # 修改密码过期后用户锁定时间为30天
            chage --inactive 30 ${username}
            LOG "INFO" "change password expiration policy of user \"${username}\" success."
        else
            LOG "WARN" "user \"${username}\" does not exist."
        fi
    done
    # sopuser mindays设置
    chage --mindays 7 sopuser
    chage -I -1 sopuser
}

main