#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: update_aide_db.sh
# Description: 刷新aide数据库
##############################################################################

SELF_FILE=$(basename $0)

############################################################
# Description: 打印日志
############################################################
function LOG() {
    level=${1}
    message=${2}
    echo "[$(date +"%Y-%m-%d %H:%M:%S")] [${SELF_FILE}] [${level}] | ${message}"
}

function main(){
    LOG "INFO" "Start to update aide db"
    local aide_conf_file="/etc/aide.d/aide_os.conf"
    local aide_db_file="/var/lib/aide/aide_os.db.gz"
    local aide_new_db_file="/var/lib/aide/aide_os.db.new.gz"
    
    if [ -f ${aide_conf_file} ];then
        # 初始化成功后，会生成/var/lib/aide/aide_os.db.new.gz文件
        LOG "INFO" "Start to execute cmd: aide -c ${aide_conf_file} --init"
        aide -c ${aide_conf_file} --init
        if [ $? -ne 0 ];then
            LOG "ERROR" "aide -c ${aide_conf_file} --init failed"
            return 1
        fi
        # 使能AIDE基线数据库
        mv ${aide_new_db_file} ${aide_db_file}
        if [ $? -ne 0 ];then
            LOG "ERROR" "mv ${aide_new_db_file} ${aide_db_file} failed"
            return 1
        fi
    else
        LOG "WARNING" "${aide_conf_file} is not exist."
    fi
    LOG "INFO" "Finish to update aide db"
    return 0
}

main