#!/usr/bin/env bash

##############################################
#    add file protect
#
######################################################################

install_file_protect()
{
    echo "begin install_file_protect"
    local fp="/opt/entTools/fileprotect/"
    local sp=/usr/lib/systemd/system
    local sn=lock.service

    if [[ ! -d ${fp} ]]; then
        echo "no fileprotect dir"
        return 0
    fi
    #安装服务文件
    cp ${fp}/systemd/${sn} ${sp}
    chown root:root ${sp}/${sn}
    chmod 644 ${sp}/${sn}

    #服务脚本与目录拷贝
    serviceDir=/etc/lock
    serviceConfDir=${serviceDir}/lock.d
    scriptsDir=${serviceDir}/run
    rproConfDir=${serviceConfDir}/rules/pro_r/
    proConfDir=${serviceConfDir}/pro/
    rdbConfDir=${serviceConfDir}/rules/db_r/
    dbConfDir=${serviceConfDir}/db/
    osConfDir=${serviceConfDir}/rules/os/

    [[ -d ${serviceConfDir} ]] && rm -rf ${serviceConfDir}
    mkdir -p ${scriptsDir}
    mkdir -p ${rproConfDir}
    mkdir -p ${proConfDir}
    mkdir -p ${rdbConfDir}
    mkdir -p ${dbConfDir}
    mkdir -p ${osConfDir}


    chmod 755 ${serviceDir}
    chmod 700 ${scriptsDir}

    chmod 755 ${serviceConfDir}
    chmod 700 ${serviceConfDir}/rules

    chmod 700 ${rproConfDir}
    chmod 700 ${proConfDir}

    chmod 700 ${rdbConfDir}
    chmod 700 ${dbConfDir}

    chmod 700 ${osConfDir}

    cp -rf ${fp}/* ${scriptsDir}
    chmod 540 ${scriptsDir}/*.sh
    chmod 750 ${scriptsDir}/inc
    chmod 750 ${scriptsDir}/systemd
    chmod 750 ${scriptsDir}/cfg
    chmod 540 ${scriptsDir}/cfg/illegalPath.lst
    chmod 540 ${scriptsDir}/inc/log.inc
    chmod 540 ${scriptsDir}/systemd/lock.service


    chown -R root:root ${serviceDir}
    chown ossadm:ossgroup ${proConfDir}
    echo "ossadm ALL=(root) NOPASSWD: /etc/lock/run/alock.sh" >> /etc/sudoers
    echo "ossadm ALL=(root) NOPASSWD: /etc/lock/run/sunlock.sh" >> /etc/sudoers
	local temp=$(cat /etc/sudoers | grep "sdlock.sh")
    if [[ -z ${temp} ]]
    then
        echo "ossadm ALL=(root) NOPASSWD: /etc/lock/run/sdlock.sh" >> /etc/sudoers
    fi
    systemctl stop lock
    systemctl disable lock
    echo "finish install_file_protect"
    return 0
}

#配置文件保护微服务
install_file_protect