#!/bin/bash
################################################################################
## Copyright:   HUAWEI Tech. Co., Ltd.
## Filename:    log.sh
## Description: Log Records
## Version:     CampusInsight V100R21C00
## Created:     Saturday, 4 10, 2021
################################################################################

################################################################################
# Function: syslog
# Description: Important operation must record to syslog
# Parameters :
#   input:
#   $1: message
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
# Others: N/A
################################################################################
function syslog()
{
    local message=$1
    which logger >/dev/null 2>&1
    [ "$?" -ne "0" ] && return 0;
    logger -p local0.notice -i "${message}"

}

################################################################################
# Function: main
# Description: Important operation must record to syslog
# Parameters :
#   input:
#   $1: collect_path ; ${@:2:$#-2}: input_param ;  ${@:$#-1:1}: start_time ; ${@: -1}: end_time
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
# Others:
#   /opt/oss/share/manager/SMPAgentService/tempDir/task_{task_id}_Analyzer-{node_num}({node_ip})
#   -collectType a -collectnum v
#   2021-04-07 13:04:39
#   2021-04-07 17:04:39
################################################################################
function main()
{
    # process the input params: 第一个值为路径，后面有一段是paramlist中的
    syslog 'Start to deal with the input params.'
    collect_path=$1
    custom_param=${@:2:$#-5}
    start_time=${@:$#-3:1}'@'${@:$#-2:1}
    end_time=${@:$#-1:1}'@'${@: -1}
    sudo /opt/sudobin/execute.sh /opt/oss/log_collect_tool/log_collect_pkg.tar /root/$[$(date +%s%N)/1000000] exec_python_collect.sh -collect_path ${collect_path} ${custom_param} -start_time ${start_time} -end_time ${end_time}
    syslog 'End to execute sudo script.'
}

main $*
