#!/bin/bash

###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
# File name: config_mellanox_and_reboot.sh
# Description: 关闭ARM Euler安全启动签名校验 & 重启操作系统
###############################################################################

CUR_PATH=$(cd `dirname $0`;pwd)
touch ${CUR_PATH}/running_flag
# 判断当前用户是否为root用户
uid=$(id | sed 's/uid=\([0-9]*\)(.*/\1/')
if [[ "${uid}" != "0" ]]; then
  echo "You must be root to execute this script."
  exit 1
fi

# 修改grub文件，关闭安全启动签名校验并重启操作系统
grub_status=$(grep "module.sig_enforce" /etc/default/grub)
if [[ x${grub_status} == x ]]; then
  echo "grub already modified. ready to install mellanox."
  touch ${CUR_PATH}/grub_config_flag
  exit 0
else
  logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1)  [config /etc/default/grub]Start to config grub."
  sed 's/module.sig_enforce //g' /etc/default/grub > /etc/default/grub.bak
  mv /etc/default/grub.bak /etc/default/grub
  chmod 644 /etc/default/grub
  grub2-mkconfig -o /boot/efi/EFI/euleros/grub.cfg > /dev/null 2>&1
  logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1)  [config /etc/default/grub]Config grub successfully."
  touch ${CUR_PATH}/grub_config_flag
  shutdown -r now
fi
