#!/bin/bash

CUR_PATH=$(cd `dirname $0`;pwd)
CONF_DIR="${CUR_PATH}"/conf
STOP_LOCK_FLAG=/tmp/stop_all.lock
source "${CUR_PATH}"/../shscript/util.sh

# ---------------------------------------------------------------------------- #
#                                                #
# ---------------------------------------------------------------------------- #
stop_cluster()
{
    PRINT_LOG INFO "begin to stop FI and analyse"
    cp ${CUR_PATH}/conf/* ${CUR_PATH}/../conf
    time="$(date "+%Y%m%d%H%M")"
    set_one_param "task_id" "${time}"
    set_one_param "selectedNetType" "stop"
    set_one_param "deploy_mode" "stop_operate"
    cd ${CUR_PATH}/../script
    ${CUR_PATH}/../script/python/bin/python  launch.pyc cloud.bg_frame.resolve &
    PID="$!"
    wait "$PID"
    if [[ "$?" != "0" ]];then
        PRINT_LOG INFO "stop failed"
        logger -p local0.error "$(who -m | cut -d\( -f2 |cut -d\) -f1);execute stop.sh failed."
        return 1
    fi
    if [[ -f ${CONF_DIR}/silent.properties ]];then
        rm -f ${CONF_DIR}/silent.properties
    fi
    if [[ -f ${CUR_PATH}/../conf/silent.properties ]];then
        rm -f ${CUR_PATH}/../conf/silent.properties
    fi
    if [[ -f ${STOP_LOCK_FLAG} ]];then
        rm -f ${STOP_LOCK_FLAG}
    fi
    PRINT_LOG INFO "stop success"
    return 0
}

init()
{
    > ${CONF_DIR}/silent.properties

}

main()
{
    logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1);execute stop.sh starting"
    is_installing "${STOP_LOCK_FLAG}" || return 1
    init || return 1
    pre_check || return 1
    stop_cluster || return 1
    logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1);execute stop.sh successfully."
}

main $*
exit $?
