"""
custom upg param
"""
# -*- coding: utf-8 -*
import json
import os
import pyzenith
from util import ossext

CREATE_TEMP_TABLE = "CREATE TEMPORARY TABLE #TMP_CRON AS (SELECT CRON_TRIGGERS.TRIGGER_NAME " \
                    "AS TRIGGER_NAME,CRON_TRIGGERS.TRIGGER_GROUP " \
                    "AS TRIGGER_GROUP FROM CRON_TRIGGERS LEFT JOIN CRON_SIMPLE_TRIGGERS " \
                    "ON CRON_TRIGGERS.TRIGGER_NAME=CRON_SIMPLE_TRIGGERS.TRIGGER_NAME " \
                    "WHERE CRON_TRIGGERS.TRIGGER_TYPE='SIMPLE' " \
                    "AND CRON_SIMPLE_TRIGGERS.TRIGGER_NAME IS NULL)"
DELETE_CRON_BLOB = "DELETE FROM CRON_BLOB_TRIGGERS WHERE TRIGGER_NAME IN " \
                   "(SELECT #TMP_CRON.TRIGGER_NAME FROM #TMP_CRON) AND TRIGGER_GROUP IN " \
                   "(SELECT #TMP_CRON.TRIGGER_GROUP FROM #TMP_CRON)"
DELETE_CRON_SIMPLE = "DELETE FROM CRON_SIMPLE_TRIGGERS WHERE TRIGGER_NAME IN " \
                     "(SELECT #TMP_CRON.TRIGGER_NAME FROM #TMP_CRON) AND TRIGGER_GROUP IN " \
                     "(SELECT #TMP_CRON.TRIGGER_GROUP FROM #TMP_CRON)"
DELETE_CRON_SIMPROP = "DELETE FROM CRON_SIMPROP_TRIGGERS WHERE TRIGGER_NAME IN " \
                      "(SELECT #TMP_CRON.TRIGGER_NAME FROM #TMP_CRON) AND TRIGGER_GROUP IN " \
                      "(SELECT #TMP_CRON.TRIGGER_GROUP FROM #TMP_CRON)"
DELETE_CRON_CRON = "DELETE FROM CRON_CRON_TRIGGERS WHERE TRIGGER_NAME IN " \
                   "(SELECT #TMP_CRON.TRIGGER_NAME FROM #TMP_CRON) AND TRIGGER_GROUP IN " \
                   "(SELECT #TMP_CRON.TRIGGER_GROUP FROM #TMP_CRON)"
DELETE_CRON_FIRED = "DELETE FROM CRON_FIRED_TRIGGERS WHERE TRIGGER_NAME IN (SELECT #TMP_CRON.TRIGGER_NAME " \
                    "FROM #TMP_CRON) AND TRIGGER_GROUP IN (SELECT #TMP_CRON.TRIGGER_GROUP FROM #TMP_CRON)"
DELETE_CRON_TRIGGERS = "DELETE FROM CRON_TRIGGERS WHERE TRIGGER_NAME IN " \
                       "(SELECT #TMP_CRON.TRIGGER_NAME FROM #TMP_CRON) AND TRIGGER_GROUP IN " \
                       "(SELECT #TMP_CRON.TRIGGER_GROUP FROM #TMP_CRON)"
DELETE_CRON_JOB_DETAILS = "DELETE FROM CRON_JOB_DETAILS WHERE JOB_NAME IN " \
                          "(SELECT #TMP_CRON.TRIGGER_NAME FROM #TMP_CRON) AND JOB_GROUP IN " \
                          "(SELECT #TMP_CRON.TRIGGER_GROUP FROM #TMP_CRON)"
DROP_TEMP_TABLE = "DROP TABLE IF EXISTS #TMP_CRON"


def main():
    """
    into
    """
    app_dir, app_name = get_app_dir()
    app_version_file = get_app_version(app_dir, app_name)
    conn_info, keys = load_cron_connectdata(app_version_file)
    for key in keys:
        if "databases" in key and "crondb" in conn_info[key]:
            clean_crondb(conn_info, keys)
            return
    app_version_file = get_app_version("/opt/oss/manager/apps/MCCommonService/etc/sysconf", "MCCommonService")
    conn_info, keys = load_cron_connectdata(app_version_file)
    clean_crondb(conn_info, keys)


def load_cron_connectdata(app_version_file):
    conn_info_fr = open(app_version_file, 'r')
    conn_info = json.load(conn_info_fr)
    conn_info_fr.close()
    keys = list(conn_info.keys())
    return conn_info, keys


def get_app_dir():
    """
    into
    """
    mccommon_dir = "/opt/oss/manager/apps/MCDeployService/etc/sysconf"
    uniep_dir = "/opt/oss/manager/apps/UniEPLiteService/etc/sysconf"
    if os.path.isdir(mccommon_dir):
        return mccommon_dir, 'MCDeployService'
    if os.path.isdir(uniep_dir):
        return uniep_dir, 'UniEPLiteService'
    print("app dir is not exist")
    return "", ""


def get_app_version(app_dir, app_name):
    """
    into
    """
    for item in os.listdir(app_dir):
        action_file = str(item)
        if action_file.startswith(app_name) and action_file.endswith('.json'):
            return os.path.join(app_dir, action_file)
    print("can not find app_version_file")
    return ""


def clean_crondb(conn_info, keys):
    """
    clean crondb
    """
    for key in keys:
        if "databases" in key and "crondb" in conn_info[key]:
            for crondb_info in conn_info[key]["crondb"]:
                pwd_tmp = crondb_info["passwd"]
                host = crondb_info["serverName"]
                port = str(crondb_info["port"])
                db_type = crondb_info["type"]
                if db_type != 'zenith':
                    return
                try:
                    conn = pyzenith.connect(user='crondb', passwd=ossext.Cipher.decrypt(pwd_tmp), host=host, port=port)
                    curs = conn.cursor()
                    curs.execute(CREATE_TEMP_TABLE)
                    curs.execute(DELETE_CRON_BLOB)
                    curs.execute(DELETE_CRON_SIMPLE)
                    curs.execute(DELETE_CRON_SIMPROP)
                    curs.execute(DELETE_CRON_CRON)
                    curs.execute(DELETE_CRON_FIRED)
                    curs.execute(DELETE_CRON_TRIGGERS)
                    curs.execute(DELETE_CRON_JOB_DETAILS)
                    curs.execute(DROP_TEMP_TABLE)
                    conn.commit()
                    print("Clean crondb success")
                    break
                except Exception as ex:
                    raise Exception("failed to execute clean crondb") from ex
                finally:
                    curs.close()
                    conn.close()


main()
