"""
check smpmanagerservice db used space and table over 2G
"""
import json
import os
import sys
import time
from dfsutil import logmgr
from util import ossext
from util import httpclient
sys.path.append("/opt/oss/manager/apps/SMPAgentService/dbdriver_zenith/pyscript/zenith")
import pyzenith
LOGGER = logmgr.LoggerFactory().getLogInst()

def doDelayMision():
    """
    doDelayMision
    """
    JSON_PATH=os.getenv("SMPMANAGERSERVICE_JSON")
    dbName=None
    host=None
    port=None
    user=None
    passWd=None
    query_hc_jobs = "SELECT JOB_ID,PROJECT_ID,NODE_IP,SCENES_ID,CREATE_TIME,CYCLE,FREQUENCY,REMAINING_TIMES,START_TIME,END_TIME FROM TBL_SMP_SCHEDULE"
    try:
        with open(JSON_PATH,"r") as dbJson:
            jdata=json.load(dbJson)
            dbArry=jdata.get('databases').get('smpmanagerservicedb')
            dbInfo=dbArry[0]
            passWd=ossext.Cipher.decrypt(dbInfo.get('passwd'))
            dbName=dbInfo.get('dbName')
            host=dbInfo.get('accessHost')
            port=dbInfo.get('accessPort')
            user=dbInfo.get('user')

            conn = pyzenith.connect(host, user, passWd, str(port))
            # 创建cursor
            cs = conn.cursor()
            # 查询当前配置的健康检查定时任务
            cs.execute(query_hc_jobs)
            # 调用fetchall方法获取所有结果
            rows = cs.fetchall()
            for row in rows:
                LOGGER.info("begin delay for " + str(row[0]))
                executeForRow(row,cs)

            # 关闭cursor
            cs.close()
            # 关闭数据库连接
            conn.close()
    except Exception as ex:
        LOGGER.error("doDelayMision get dbinfo occur exception.")
        LOGGER.error(ex)

def executeForRow(row,cs):
    '''
    delay schedule row
    '''
    JOB_ID=str(row[0])
    PROJECT_ID=str(row[1])
    NODE_IP=str(row[2])
    SCENES_ID=str(row[3])
    CREATE_TIME=str(row[4])
    CYCLE=str(row[5])
    FREQUENCY=str(row[6])
    REMAINING_TIMES=int(row[7])
    if int(FREQUENCY) > 0:
        REMAINING_TIMES=REMAINING_TIMES - 1
    START_TIME=int(row[8]) + int(CYCLE)
    END_TIME=str(row[9])
    sendRequestToCornServer(JOB_ID,PROJECT_ID,NODE_IP,SCENES_ID,CREATE_TIME,CYCLE,FREQUENCY,REMAINING_TIMES,START_TIME)
    updateRecordSql="update tbl_smp_schedule set START_TIME=" + str(START_TIME) + ",REMAINING_TIMES=" + str(REMAINING_TIMES) + " where JOB_ID='" + str(JOB_ID) + "'"
    LOGGER.info("updateSql=" + updateRecordSql)
    cs.execute(updateRecordSql)
    cs.execute("commit")
    updateRes=cs.fetchall()
    LOGGER.info("updateRes=" + str(updateRes))

def sendRequestToCornServer(JOB_ID,PROJECT_ID,NODE_IP,SCENES_ID,CREATE_TIME,CYCLE,FREQUENCY,REMAINING_TIMES,START_TIME):
    client=httpclient.IRHttpClient()
    cronTime=time.strftime("%S %M %H %d %m ? %Y",time.localtime(int(START_TIME)/1000))
    URL='/rest/plat/cron/v1/schedules/SMPManagerService_' + JOB_ID + ''
    DATA={"action":"/rest/smpmanagerservice/v1/healthcheck/cron/" + JOB_ID + "","description":"Health Check Schedule: All","type":"CRON","periodUnit":"FREE","time":"" + str(cronTime) + ""}
    LOGGER.info("URL=" + str(URL))
    LOGGER.info("DATA=" + str(DATA))
    LOGGER.info("CRONTIME="+str(cronTime))
    resp=client.put(URL,DATA)
    LOGGER.info("cronResp=" + str(resp))

if __name__ == '__main__':
    doDelayMision()
