#!/bin/bash

# 脚本工作路径
SCRIPT_PATH=$(cd $(dirname $0);pwd)

# 脚本名称
SELF_FILE=$(basename $0)

# 脚本日志路径
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog/"

#脚本日志文件
LOG_FILE="${LOG_PATH}/${SELF_FILE}.log"

# 配置工作目录
WORK_PATH="/opt/upgrade/easysuite_upgrade/workpath/"

# 产品名 plandata.json productnam
PRODUCT_NAME=""

# 升级路径 plandata.json src_version-des_version
UPGRADE_PATH=""

# WORK_PATH/UPGRADE_PATH/workpath-PRODUCT_NAME/
CONFIG_PATH=""

# INPUT文件路径  plandata.json
INPUT_FILE="${2}/plandata.json"

# 脚本临时工作路径
CONFIG_DIR="/opt/oss/log/manager/easysuite_upgrade_config"
[ ! -e "${CONFIG_DIR}" ] && mkdir -p "${CONFIG_DIR}"
TMP_PATH="${CONFIG_DIR}/01_post_rollback_dfs_woodpecker_config_$(date '+%s')"

# common.sh脚本目录
COMMON_SCRIPT_PATH=$(realpath "${SCRIPT_PATH}/../../common/NCE-Common")

##########################################
#  修改 woodpecker_global_sample_rate 字段
##########################################
function modify_woodpecker_global_sample_rate()
{
    tmp_product_file="${1}"
    pre_config_json_file="${2}"
    python <<END
import json
with open('${tmp_product_file}', 'r', encoding='utf-8') as r_stream:
    file_data = json.load(r_stream)
    with open('${pre_config_json_file}', 'r', encoding='utf-8') as pre_r_stream:
        pre_file_data = json.load(pre_r_stream)
        pre_upgrade_conf_value = pre_file_data.get('woodpecker_global_sample_rate')
        with open('${tmp_product_file}', 'w', encoding='utf-8') as w_stream:
            productext_json = file_data.get('productext', {})
            if pre_upgrade_conf_value == '-1':
                if productext_json.get('woodpecker_global_sample_rate'):
                    del productext_json['woodpecker_global_sample_rate']
            else:
                productext_json.update({'woodpecker_global_sample_rate': pre_upgrade_conf_value})
            json.dump(file_data, w_stream)
END
}

##########################################
#  判断 NCE产品
##########################################
function check_nce_product()
{
    file_path="${1}"
    python <<END
import json
with open('${file_path}', 'r', encoding='utf-8') as r_stream:
    products_json = json.load(r_stream)
    producttype = products_json.get('producttype', '')
    productsubtype = products_json.get('productext', {}).get('productsubtype', '')
    if 'NCE' in producttype or 'NCE' in productsubtype:
        print('true')
    else:
        print('false')
END
}

##########################################
#  删除配置文件
##########################################
function delete_config_file()
{
    CONFIG_PATH="${WORK_PATH}/${UPGRADE_PATH}/workpath-${PRODUCT_NAME}/pre_upgrade"
    config_file="${CONFIG_PATH}/pre_woodpecker_global_config.json"
    if [ -f "${config_file}" ]
    then
        # 删除配置文件
        rm -f ${config_file}
        LOG_PRINT "INFO" "Delete config_file,${config_file}"
    fi
    return 0
}

##########################################
#  恢复 woodpecker_global_sample_rate 字段
##########################################
function restore_woodpecker_global_sample_rate()
{
    # 创建临时工作目录
    mkdir -p ${TMP_PATH}

    # 查询 product_NCE.json
    query_product "${TMP_PATH}" "${PRODUCT_NAME}" || return 1
    
    # 判断产品信息
    is_nce_product=$(check_nce_product "${TMP_PATH}/product_${PRODUCT_NAME}.json")
    if [ "${is_nce_product}" == "false" ]
    then
        LOG_PRINT "INFO" "Not NCE product, ${SELF_FILE} exit."
        rm -rf ${TMP_PATH}
        return 0
    fi
    
    CONFIG_PATH="${WORK_PATH}/${UPGRADE_PATH}/workpath-${PRODUCT_NAME}/pre_upgrade"
    config_file="${CONFIG_PATH}/pre_woodpecker_global_config.json"
    
    if [ -f "${config_file}" ]
    then
        # 修改 product_NCE.json
        modify_woodpecker_global_sample_rate "${TMP_PATH}/product_${PRODUCT_NAME}.json" "${config_file}"

        # 更新 product_NCE.json
        modify_product "${TMP_PATH}/product_${PRODUCT_NAME}.json" || return 1
    fi

    # 退出清理临时目录
    rm -rf ${TMP_PATH}
}

##########################################
#  主入口
##########################################
function main()
{
    # 加载公共模块
    source ${COMMON_SCRIPT_PATH}/common.sh

    # 检查执行用户
    check_ossadm_user || return 1

    # 初始化参数
    initial_params "${INPUT_FILE}" || return 1

    # 加载平台环境变量
    source /opt/oss/manager/bin/engr_profile.sh

    # 更新全局采样率字段
    restore_woodpecker_global_sample_rate || return 1
    
    # 删除配置文件
    delete_config_file

    # 默认退出 0
    return 0
}

main "$@"
exit 0