#!/bin/bash

# 脚本工作路径
SCRIPT_PATH=$(cd $(dirname $0);pwd)

# 脚本名称
SELF_FILE=$(basename $0)

# 脚本日志路径
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog/"

#脚本日志文件
LOG_FILE="${LOG_PATH}/${SELF_FILE}.log"

# 配置工作目录
WORK_PATH="/opt/upgrade/easysuite_upgrade/workpath/"

# 产品名 plandata.json productnam
PRODUCT_NAME=""

# 升级路径 plandata.json src_version-des_version
UPGRADE_PATH=""

# WORK_PATH/UPGRADE_PATH/workpath-PRODUCT_NAME/
CONFIG_PATH=""

# INPUT文件路径  plandata.json
INPUT_FILE="${2}/plandata.json"

# 脚本临时工作路径
TMP_PATH="/opt/oss/log/manager/easysuite_upgrade_config/01_pre_upgrade_dfs_woodpecker_config_$(date '+%s')"

# common.sh脚本目录
COMMON_SCRIPT_PATH=$(realpath "${SCRIPT_PATH}/../../common/NCE-Common")

##########################################
#  保存升级前配置信息,读取并保存 woodpecker_global_sample_rate 字段
##########################################
function save_woodpecker_global_sample_rate()
{
    file_path="${1}"
    save_file="${2}"
    python <<END
import json
with open('${file_path}', 'r', encoding='utf-8') as r_stream:
    productext_json = json.load(r_stream).get('productext', {})
    with open('${save_file}', 'w', encoding='utf-8') as w_stream:
        save_dic = {}
        save_dic['woodpecker_global_sample_rate'] = productext_json.get('woodpecker_global_sample_rate', '-1')
        json.dump(save_dic, w_stream)
END
}

##########################################
#  判断 NCE产品
##########################################
function check_nce_product()
{
    file_path="${1}"
    python <<END
import json
with open('${file_path}', 'r', encoding='utf-8') as r_stream:
    products_json = json.load(r_stream)
    producttype = products_json.get('producttype', '')
    productsubtype = products_json.get('productext', {}).get('productsubtype', '')
    if 'NCE' in producttype or 'NCE' in productsubtype:
        print('true')
    else:
        print('false')
END
}

##########################################
#  备份升级前配置信息
##########################################
function backup_pre_config()
{
    # 创建临时工作目录
    mkdir -p ${TMP_PATH}

    # ossadm: 创建工作路径
    CONFIG_PATH="${WORK_PATH}/${UPGRADE_PATH}/workpath-${PRODUCT_NAME}/pre_upgrade"
    LOG_PRINT "INFO" "Start to initialize the directory:${CONFIG_PATH}"
    if [ ! -d "${CONFIG_PATH}" ]
    then
        mkdir -p ${CONFIG_PATH}
    fi
    LOG_PRINT "INFO" "Finished to initialize the directory:${CONFIG_PATH}"

    # 生成升级前配置文件
    config_file="${CONFIG_PATH}/pre_woodpecker_global_config.json"

    # 查询 product_NCE.json
    query_product "${TMP_PATH}" "${PRODUCT_NAME}" || return 1
    
    # 判断产品信息
    is_nce_product=$(check_nce_product "${TMP_PATH}/product_${PRODUCT_NAME}.json")
    if [ "${is_nce_product}" == "false" ]
    then
        LOG_PRINT "INFO" "Not NCE product, ${SELF_FILE} exit."
        rm -rf ${TMP_PATH}
        return 0
    fi

    # 备份
    save_woodpecker_global_sample_rate "${TMP_PATH}/product_${PRODUCT_NAME}.json" ${config_file}

    # 退出清理临时目录
    rm -rf ${TMP_PATH}

    # 正常退出
    return 0
}

##########################################
#  主入口
##########################################
function main()
{
    # 加载公共模块
    source ${COMMON_SCRIPT_PATH}/common.sh

    # 检查执行用户
    check_ossadm_user || return 1

    # 初始化参数
    initial_params "${INPUT_FILE}" || return 1

    # 加载平台环境变量
    source /opt/oss/manager/bin/engr_profile.sh

    # 备份升级前配置
    backup_pre_config || return 1

    # 默认退出 0
    return 0
}

main "$@"
exit 0
