#!/bin/bash
##############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: refresh_aide_db_and_recover_auidt_rules.sh
# Description: 1、刷新aide数据库；2、恢复audit审计规则
##############################################################################

WORKFORDER=$(dirname $(readlink -f $0))
LOG_FILE="/var/log/refresh_aide_db_and_recover_auidt_rules.log"
SUDO_PKG="/tmp/common_es_sudobin_pkg.tar"

##############################################################################
# Description： 恢复audit审计规则
# @Param:  null
##############################################################################
function recover_audit_rules(){
    # 判断操作系统类型，非suse系统，跳过
    cat /proc/version | grep -i "suse" || return 0
    # 判断内核版本，涉及的版本需要执行恢复
    local affected_version="4.12.14-122.150-default 4.12.14-122.153-default 4.12.14-122.156-default"
    local kernel_version=$(uname -r)
    # 版本不涉及，跳过
    [[ "${affected_version}" =~ "${kernel_version}" ]] || return 0
    # 执行恢复
    echo "Start to recover audit rules" >> "${LOG_FILE}"
    auditctl -R /etc/audit/audit.rules
    if [ $? -ne 0 ];then
        echo "Failed to execute cmd: auditctl -R /etc/audit/audit.rules" >> "${LOG_FILE}"
        echo "Failed to recover audit rules" >> "${LOG_FILE}"
        return 1
    fi
    return 0
}

##############################################################################
# Description：升级完操作系统后，更新AIDE数据库文件
##############################################################################
function update_aide_db(){
    echo "Start to update aide db" >> "${LOG_FILE}"
    local aide_conf_file="/etc/aide.d/aide_os.conf"
    local aide_db_file="/var/lib/aide/aide_os.db.gz"
    local aide_new_db_file="/var/lib/aide/aide_os.db.new.gz"
    
    if [ -f ${aide_conf_file} ];then
        # 初始化成功后，会生成/var/lib/aide/aide_os.db.new.gz文件
        echo "Start to execute cmd: aide -c ${aide_conf_file} --init"
        aide -c ${aide_conf_file} --init &>> "${LOG_FILE}"
        if [ $? -ne 0 ];then
            echo "aide -c ${aide_conf_file} --init failed" >> "${LOG_FILE}"
            return 1
        fi
        # 使能AIDE基线数据库
        mv ${aide_new_db_file} ${aide_db_file}
        if [ $? -ne 0 ];then
            echo "mv ${aide_new_db_file} ${aide_db_file} failed" >> "${LOG_FILE}"
            return 1
        fi
    else
        echo "${aide_conf_file} is not a file" >> "${LOG_FILE}"
    fi
    return 0
}

##############################################################################
# Description：clean
##############################################################################
function clean_pkg(){
    rm "${SUDO_PKG}"
}

##############################################################################
# Description：main
##############################################################################
function main(){
    recover_audit_rules || return $?
    update_aide_db || return $?
    clean_pkg
}
main
exit $?