#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# -*- coding: utf-8 -*-
"""检查操作系统分区"""

import os
import time
from .common_utils.check_task import OSCheckTask, OSCheckConfig

_config_params = {
    # 检查项名称
    "task_name": 'task_check_os_partition',
    # sudo包相对路径
    "sudo_pkg_loc": "es_check_sudobin_pkg.tar",
    # sudo包临时解压目录
    "sudo_tmp_path": f"/opt/check_os_partition_{int(time.time())}",
    # 当前目录
    "upload_src_path": os.path.split(os.path.realpath(__file__))[0],
    # 上传目录
    "upload_trg_path": "/opt/oss/tmp",
}


def execute_task_check(kvs):
    """
    执行检查任务
    :param kvs: 全局字典
    :return: bool 检查项是否通过
    """
    sudo_script = "check_os_partition.sh"
    check_result = "/var/log/os_partition_check_result"
    task = OSCheckTask(OSCheckConfig(_config_params), kvs)
    # 上传提权包到所有节点
    if not task.upload_sudo_pkg():
        return False
    # 提权执行检查脚本，并检查结果
    if not (task.execute_sudo_script(sudo_script) and task.check_results(check_result)):
        return False
    # 清理上传sudo包
    if not task.rm_sudo_pkg():
        return False
    task.finish()
    return True


def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: bool 是否需要执行
    """
    return True


def exe(kvs):
    """
    功能描述：任务执行入口
    :param kvs: 全局字典
    :return: list 检查结果
    """
    return [[('', '', execute_task_check(kvs))]]
