#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# -*- coding: utf-8 -*-
"""
功 能：检查os类型
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2023-03-11 12:00 创建
"""
from .common_utils.check_task import OSCheckTask, OSCheckConfig

_config_params = {
    # 检查项名称
    "task_name": 'task_check_os_type',
}


def execute_task_check(kvs):
    """
    执行检查任务
    :param kvs: 全局字典
    :return: bool 检查项是否通过
    """
    task = OSCheckTask(OSCheckConfig(_config_params), kvs)
    if not task.check_nodes_os_type_consistence():
        return False
    task.finish()
    return True


def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: bool 是否需要执行
    """
    return ('id_upgrade_os' in kvs.get('upgrade_item', "") and
            'id_protection_hot' == kvs.get("protection", ""))


def exe(kvs):
    """
    功能描述：任务执行入口
    :param kvs: 全局字典
    :return: list 检查结果
    """
    return [[('', '', execute_task_check(kvs))]]
