#!/bin/bash
##############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: check_opt_space.sh
# Description: 检查opt空间
##############################################################################

#########################
# Description: 程序主入口
#########################
check_sopuser_valid() {
    id sopuser &>> /dev/null
    if [ $? -ne 0 ]; then
        log "INFO" "The sopuser user does not exist, do not need to check sopuser valid"
        return 0
    fi
    local expire_time=$(chage -l 'sopuser' 2>/dev/null | grep 'Password expires' | awk -F: '{print $2}')
    if echo "${expire_time}" | grep "never" &>> /dev/null
    then
        log "INFO" "check sopuser valid is ok"
        return 0
    fi
    local expire_num=$(date -d "${expire_time}" +%s)

    local offset_day=$(date -I -d '+30 day')
    local offset_num=$(date -d "${offset_day}" +%s)

    if [ "${offset_num}" -gt "${expire_num}" ]; then
        log "ERROR" "sopuser password will expire in less than 30 days"
        log "INFO" "Please change the password of the sopuser user."
        return 1
    else
        log "INFO" "Check the validity period of the sopuser user is ok."
    fi
};

#########################
# Description: 日志方法
#########################
function log() {
    log_type=$1
    mes=$2
    echo "$(date '+%Y-%m-%d %H:%M:%S') $log_type $mes"
}

check_sopuser_valid
exit $?