# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from utils.manager import Manager


class AlarmReceiveParam(object):
    """ 告警接收参数(管理面上配置的参数) """

    def __init__(self):
        self.node_ip = ""
        self.notify_id = ""
        self.port = 161
        self.type = "TaiShan"
        self.type_alias = ""
        self.snmp_user = ""
        self.snmp_private = ""
        self.snmp_auth = ""
        self.snmp_private_pwd = ""
        self.snmp_auth_pwd = ""
        self.ext_field = ""

    def get_json(self):
        return {
            "nodeIP": self.node_ip,
            "notifyID": self.notify_id,
            "port": self.port,
            "type": self.type,
            "typeAlias": self.type_alias,
            "snmpUser": self.snmp_user,
            "snmpPriv": self.snmp_private,
            "snmpAuth": self.snmp_auth,
            "snmpPrivPwd": self.snmp_private_pwd,
            "snmpAuthPwd": self.snmp_auth_pwd,
            "extField": self.ext_field
        }

    def __bool__(self):
        return self.node_ip != "" and self.notify_id != ""

    def __str__(self):
        return f"[user:{self.snmp_user}][ip:{self.node_ip}]"


def get_alarm_receive_param(node_ip):
    """
    根据管理面已经配置的告警接收参数，返回node_ip对应的告警配置实例 Alarm
    :param node_ip: 服务器/交换机/FC的IP地址
    :return: AlarmReceiveParam
    """
    alarm_receive = AlarmReceiveParam()
    for alarm_info in Manager().alarm_receive_info:
        config_node_ip = alarm_info.get("nodeIP", "")
        if config_node_ip != node_ip:
            continue
        alarm_receive.node_ip = config_node_ip
        alarm_receive.type_alias = alarm_info.get("nodeType", "")
        alarm_receive.snmp_user = alarm_info.get("userName", "")
        alarm_receive.snmp_private = alarm_info.get("snmpPriv", "")
        alarm_receive.snmp_private_pwd = alarm_info.get("snmpPrivPwd", "")
        alarm_receive.snmp_auth = alarm_info.get("snmpAuth", "")
        alarm_receive.snmp_auth_pwd = alarm_info.get("snmpAuthPwd", "")
        alarm_receive.notify_id = alarm_info.get("notifyID", "")
        alarm_receive.ext_field = alarm_info.get("extField", "")
        break
    return alarm_receive
