# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from constant.constant import RetCode
from data.alarm_forward_param import AlarmForwardParam
from service.service import Service
from utils.log_utils import get_logger

LOGGER = get_logger()


class SwitchService(Service):
    """ 交换机健康检查 """

    def __init__(self, service_info):
        super().__init__(service_info)

    def check_connect_cmd(self):
        return "display this"

    def get_service_alarm_forward_param(self) -> list:
        """ 获取告警转发参数 """
        LOGGER.info(f"[{self.service_info}] start to get alarm forward param")
        ret, stdout, stderr = self.execute_cmd("display snmp-agent target-host")
        if ret != 0:
            LOGGER.error(f"[{self.service_info}] get alarm forward param failed, stderr: {stderr}")
            return []
        snmp_ip, snmp_user, snmp_port = "", "", ""
        alarm_forward_param_list = []
        for line in stdout.split("\n"):
            if "IP address" in line:
                snmp_ip = line.split()[-1].strip()
            if "Security name" in line:
                snmp_user = line.split()[-1].strip()
            if "Port" in line:
                snmp_port = line.split()[-1].strip()
            if snmp_ip and snmp_user and snmp_port:
                alarm_forward_param_list.append(AlarmForwardParam(snmp_ip, snmp_user, snmp_port))
                snmp_ip, snmp_user, snmp_port = "", "", ""
        LOGGER.info(f"[{self.service_info}] get alarm forward param {alarm_forward_param_list}")
        return alarm_forward_param_list

    def build_check_function_list(self) -> list:
        """ 生成check list，列表内容为(func, RetCode)"""
        return [
            (self.check_local_alarm_ip_ping_to_service_ip, RetCode.PING_ERROR),
            (self.check_connect, RetCode.CONNECT_ERROR),
            (self.check_alarm_receive_param_exist, RetCode.ALARM_RECEIVE_PARAM_NOT_EXIST_ERROR),
            (self.check_alarm_receive_param, RetCode.ALARM_RECEIVE_PARAM_ERROR),
            (self.check_alarm_forward_param, RetCode.ALARM_FORWARD_PARAM_ERROR)
        ]
