# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import logging
import os
from logging import handlers
LOG_DIR = "/opt/oss/log/manager/HardwareAlarmCheck"
HARDWARE_ALARM_CHECK = os.path.join(LOG_DIR, "check.log")


class Logger:
    """ log 日志实例 """

    def __init__(self):
        if not os.path.exists(LOG_DIR):
            os.makedirs(LOG_DIR)
        file_handler = handlers.RotatingFileHandler(filename=HARDWARE_ALARM_CHECK, maxBytes=10 * 1024 * 1024, backupCount=3,
                                                    encoding='utf-8')  # 创建一个控制文件输出的文件操作符
        log_format = "%(asctime)s[%(thread)d][%(filename)s-line:%(lineno)d][%(levelname)s]: %(message)s"
        date_format = "[%Y-%m-%d %H:%M:%S]"
        file_handler.setFormatter(logging.Formatter(fmt=log_format, datefmt=date_format))
        logging.basicConfig(force=True, handlers=[file_handler])
        self.logger = logging.getLogger("health_check")
        self.logger.setLevel(logging.INFO)


LOGGER = Logger().logger


def get_logger():
    """ 全局日志获取方法, 会自动转储删除, 10M*3 """
    return LOGGER