# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from concurrent.futures.thread import ThreadPoolExecutor


class MultiThreadPool(object):
    """ 多线程控制工具类 """

    def __init__(self, max_pool_size=20):
        self.executor = ThreadPoolExecutor(max_workers=max_pool_size)
        self.threads = []

    def add_thread(self, func, *args, **kwargs):
        thread = ThreadItem(func, *args, **kwargs)
        self.threads.append(thread)

    def run_thread(self, i):
        return self.threads[i].execute_with_result()

    def execute_with_result(self):
        results = []
        # 修改为执行结果按照加入线程池的顺序返回
        for result in self.executor.map(self.run_thread,
                                        [index for index in range(len(self.threads))]):
            results.append(result)
        self.executor.shutdown()
        return results


class ThreadItem:
    def __init__(self, func, *args, **kwargs):
        self.func = func
        self.args = args
        self.kwargs = kwargs

    def execute_with_result(self):
        return self.func(*self.args, **self.kwargs)
