#!/bin/bash
##############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: check_route_conflicts.sh
# Description: 检查配置的路由与IP默认生成的路由冲突
##############################################################################

#########################
# Description: 检查路由
#########################
function check_route(){
    rt_array_ifcfg=()
    rt_array_routes=()
    local current_path=$(cd $(dirname $0);pwd)
    . ${current_path}/check_route_conflicts_functions
    # find all the cfg_names besides loopback.
    # ignore aliases, alternative configurations, and editor backup files
    cd /etc/sysconfig/network-scripts/ || { echo $"ERROR: /etc/sysconfig/network-scripts not exist!" >&2 ; return 1 ; }

    cfg_names=$(ls ifcfg-* | \
            sed -e "$__sed_discard_ignored_files" \
                -e '/\(ifcfg-lo$\|:\|ifcfg-.*-range\)/d' \
                -e '{ s/^ifcfg-//g;s/[0-9]/ &/}' | \
            sort -k 1,1 -k 2n | \
            sed 's/ //')

    #get routes from route-ethX files,and store in rt_array_routes array
    for name in $cfg_names; do
        get_route_from_route_files ${name}
    done
    ret=0
    index=0
    for name in $cfg_names; do
        unset PREFIX
        unset IPADDR
        unset NETMASK
        CONFIG=ifcfg-${name}
        . /etc/sysconfig/network-scripts/$CONFIG
        if [[ -z $PREFIX && -z $NETMASK ]];then
            continue
        fi

        if [ -z $IPADDR ];then
            continue
        fi

        if [ -z $PREFIX ];then
            eval $(ipcalc -p $(eval echo '$'{IPADDR}) $(eval echo '$'{NETMASK}))
        fi
        # get IPADDR and PREFIX in ifcfg-ethX
        tmp_route=`ipcalc "${IPADDR}/${PREFIX}" | grep Network |awk '{print $2}'`
        rt_array_ifcfg[$index]=$tmp_route

        for((i=0;i<${#rt_array_routes[@]};i++))
        do
            if [ "${rt_array_ifcfg[$index]}" =  "${rt_array_routes[$i]}" ];then
                echo "ERROR: route race detected in file ifcfg-$name: ${rt_array_routes[$i]}"
                ret=1
            fi
        done

        ((index++))
    done
    return $ret
}

#########################
# Description: 检查环境，仅在欧拉操作系统上做检查
#########################
function check_env(){
    cat /proc/version | grep "euleros" &>> /dev/null
    if [ $? -ne 0 ];then
        return 1
    fi
    return 0
}

#########################
# Description: 程序主入口
#########################
function check_route_conflicts(){
    check_env || return 0
	check_route || return 1
}

check_route_conflicts
exit $?