#!/bin/bash
##############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: check_service_status.sh
# Description: 检查操作系统服务状态
##############################################################################

#########################
# Description: 检查reboot服务状态
#########################
function check_reboot_status(){
    systemctl status reboot.target | grep -w masked  &>> /dev/null
    if [ $? -eq 0 ];then
        echo "ERROR: The reboot.target is in the mask state.The reboot command is unavailable,execute systemctl unmask reboot.target to unmask."
        return 1
    fi
    return 0
}

#########################
# Description: 程序主入口
#########################
function check_service_status_main(){
    check_reboot_status || return 1
    return 0
}

check_service_status_main
exit $?