#!/bin/bash

CONFIG_DIR="/opt/oss/log/manager/easysuite_upgrade_config"
CHECK_HA_FILE="${CONFIG_DIR}/check_ha_status.json"

function check_ha_status()
{
    [ -d "/opt/oss/manager/apps/DRMgrService" ] || return 0
    [ ! -e "${CONFIG_DIR}" ] && mkdir -p "${CONFIG_DIR}"
    [ -f "${CHECK_HA_FILE}" ] && rm -f "${CHECK_HA_FILE}"
    result=0
    for try in {0..3}
    do
        bash /opt/oss/manager/tools/drmgr/getsitestatus.sh -pn all -output ${CHECK_HA_FILE}
        result=$?
        if [ ${result} -ne 0 ]
        then
            sleep 1
            continue
        fi
        break
    done
    check_result=$(. /opt/oss/manager/bin/engr_profile.sh;python <<EOF
import os
import sys
import json
check_json = "${CHECK_HA_FILE}"
if not os.path.isfile(check_json):
    print("False")
    sys.exit(0)
with open(check_json, "r") as file_obj:
    dict_obj = json.load(file_obj)
if dict_obj:
    print("True")
else:
    print("False")
EOF
)
    if [ ${check_result} == "False" ]
    then
        return 0
    fi
    return 1
}

function main()
{
    check_ha_status "$@"
}

main "$@"
exit $?

