#!/bin/bash
##########################################
#远程监控
##########################################
function check()
{
    SELF_FILE=$(basename "${0}")
    log=${SELF_FILE//.sh/}.log
    echo "[$(date +"%Y-%m-%d %H:%M:%S")] [INFO] NO RUNNING ..." >>/tmp/"${log}"
    /opt/oss/manager/agent/DeployAgent/bin/ipmc_adm -cmd statusnodes -tenant "${1}" | grep -v "GW" >/tmp/status_"${log}"
    cat /tmp/status_"${log}" >>/tmp/"${log}"
    cat /tmp/status_"${log}" | grep "RUNNING" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        oldline=$(cat /tmp/status_"${log}" | wc -l)
        echo "[$(date +"%Y-%m-%d %H:%M:%S")] [INFO] HAVE RUNNING ..." >>/tmp/"${log}"
        /opt/oss/manager/agent/DeployAgent/bin/ipmc_adm -cmd statusnodes -tenant "${1}" | grep -v "GW" >/tmp/status_"${log}"
        cat /tmp/status_"${log}" >>/tmp/"${log}"
        newline=$(cat /tmp/status_"${log}" | sed "1d" | awk '{$NF=null;print $0}' | grep -c RUNNING)
        val=$(( ${oldline} - 1 ))
        if [ "${val}" -eq "${newline}" ]
        then
            echo "[$(date +"%Y-%m-%d %H:%M:%S")] [INFO] remote_check SUCCESS ..." >>/tmp/"${log}"
            return 0
        else
            return 1
        fi
    else
        return 1
    fi
}

check "$@"
exit $?