#!/bin/bash
# 获取脚本工作路径和脚本名
SCRIPT_PATH=$(cd $(dirname "${0}");pwd)
NODE_LIST=""
FAILURE_NODE_LIST=""

STOP_SERVICE_FAILED_CODE="3"
PACKAGE_NOT_EXIST_CODE="4"
NODELIST_FILE_ABNORMAL="5"
GET_RESULT_FAILED_CODE="6"
START_SERVICE_FAILED_CODE="7"

##########################################
# 获取失败节点IP
##########################################
function get_failure_node_list() {
    #操作系统补丁存放的结果文件
    local result_file="$1"
    local error_code_type="$2"
    LOG "INFO" "result_file=${result_file}; error_code_type=${error_code_type}"
    if [ "${error_code_type}" == "stop_server_failed" ];then
        FAILURE_NODE_LIST=$(grep "failure" "${result_file}"  | awk -F "=" '{print$1}' | sed ':a;N;s/\n/,/g;ta')
        return 0
    fi
    # 获取当前节点IP
    if [ ! -f "/opt/oss/manager/var/agent/managerip.conf" ] 
    then
        # 仲裁节点不存在该文件，仲裁进来就直接返回127.0.0.1作为ip返回出去
        FAILURE_NODE_LIST="127.0.0.1"
        return 0
    fi
    local local_ip=$(cat /opt/oss/manager/var/agent/managerip.conf | grep localip | awk -F'=' '{print $2}')

    # 如果当前节点升级/回滚成功后，补丁工具会创建ospatch_result_success文件，否则不存在该文件
    local local_result="/opt/patch_manager/NCE_OSPatch/ospatch_result_success"
    if [ ! -f "/opt/patch_manager/NCE_OSPatch/ospatch_result_success" ];then
        FAILURE_NODE_LIST="${local_ip}"
    fi
    local success_node_list=$(cat "${result_file}" | grep "success" | awk -F "=" '{print$1}')
    get_node_list
    for node_ip in ${NODE_LIST[@]}
    do
        # 过滤当前节点
        [ "${node_ip}" == "${local_ip}" ] && continue
        echo "${success_node_list}" | grep -w "${node_ip}" >> /dev/null
        if [ $? -ne 0 ]
        then
            if [ -z "${FAILURE_NODE_LIST}" ]
            then
                FAILURE_NODE_LIST="${node_ip}"
            else
                FAILURE_NODE_LIST="${FAILURE_NODE_LIST},${node_ip}"
            fi
        fi
    done

}



##########################################
# 获取节点IP
##########################################
function get_node_list() {
    local all_node=$(
. /opt/oss/manager/bin/engr_profile.sh
python <<PEOF
import json
import sys
node_file = r'/opt/oss/manager/etc/sysconf/nodelists.json'
manager_ips = []
try:
    with open(node_file, mode="r") as f:
        node_info = json.load(f)
    for node_id, one_node in node_info.get("nodeList", {}).items():
        manager_ips.extend([one_ip.get("IP") for one_ip in one_node.get("IPAddresses",{}) if "maintenance" in one_ip.get("usage")])
    print(" ".join(manager_ips))
    sys.exit(0)
except Exception as _:
    print("exception occur when read {}".format(node_file))
    sys.exit(1)
PEOF
)
    if [[ "${all_node}" =~ "exception" ]];then
        LOG "INFO" "query node info failed:${all_node}."
        return 2
    fi

    NODE_LIST=$(echo "${all_node}" | xargs -n1 | sort -u)
}


##########################################
# 微服务停止失败生成错误码
##########################################
function generate_stop_server_code() {
    local stop_product_result_file="/opt/patch_manager/NCE_OSPatch/stop_product_result"
    get_failure_node_list "${stop_product_result_file}" "stop_server_failed"
    generate_error_json "${1}" "${2}" "${FAILURE_NODE_LIST}"
    return 0
}


##########################################
# 获取OS升级回滚结果失败生成错误码
##########################################
function generate_get_upgrade_rollback_result_code() {
    local query_upgrade_result_file=""
    local exec_script_action="${3}"
    if [ "${3}" == "upgrade" ] || [ "${3}" == "upgrade_arb_ospatch" ]
    then
        query_upgrade_result_file="/opt/patch_manager/NCE_OSPatch/upgrade_result"
    elif [ "${3}" == "rollback" ] || [ "${3}" == "rollback_arb_ospatch" ]
    then
        query_upgrade_result_file="/opt/patch_manager/NCE_OSPatch/rollback_result"
    else
        return 0
    fi

    cat "${query_upgrade_result_file}" | grep "failure" >> /dev/null
    if [ $? -eq 0 ]
    then
        return 0
    fi
    get_failure_node_list "${query_upgrade_result_file}"
    generate_error_json "${1}" "${2}" "${FAILURE_NODE_LIST}"
    return 0
}


##########################################
# 脚本失败生成错误码
##########################################
function generate_error_json() {
    local key_error_code_type="${1}"
    local target_file="${2}"
    # 更新json文件中的具体原因
    local refresh_reason="${3}"
    local error_code_file="${SCRIPT_PATH}/../config/upgrade_rollback_os_error_code.json"
    local python_file_path="${SCRIPT_PATH}/../pyscripts"
    local python_file=""
    if [ -f "${python_file_path}/generate_error_code.py" ];then
        python_file="${python_file_path}/generate_error_code.py"
    elif [ -f "${python_file_path}/generate_error_code.pyc" ];then
        python_file="${python_file_path}/generate_error_code.pyc"
    else
        LOG "ERROR" "${python_file_path}/generate_error_code.py is not exist"
        return 1
    fi

    python_res=$(python "${python_file}" "${error_code_file}" "${key_error_code_type}" "${target_file}" "${refresh_reason}")
    if [ $? -ne 0 ];then
        LOG "ERROR" "generate error code failed.python ${python_file} ${error_code_file} ${key_error_code_type} ${target_file} ${refresh_reason}"
        LOG "ERROR" "python_res=${python_res}"
        return 1
    fi
    setfacl -m u:sopuser:r-- "${target_file}" 
    if [ $? -ne 0 ];then
        LOG "ERROR" "setfacl -m u:sopuser:r-- ${target_file} failed"
        return 1
    fi
    return 0
}



##########################################
# 脚本失败生成错误码
##########################################
function generate_error_code_main() {
    local exec_script_result="${1}"
    local exec_script_action="${2}"
    local target_file="${3}"
    LOG "INFO" "Start to execute generate_error_code_main exec_script_result=${exec_script_result},exec_script_action=${exec_script_action}."
    # 校验脚本是否是我们支持生成错误码
    echo "|pre_upgrade_ospatch|pre_rollback_ospatch|upgrade|rollback|upgrade_arb_ospatch|rollback_arb_ospatch|copy_pkg_workpath|post_check_start_service|" | grep "|${exec_script_action}|" &>/dev/null 
    if [ $? -ne 0 ]
    then
        LOG "INFO" "The current execution does not support the generation of error codes."
        return 0
    fi

    # 根据返回值转成对应关键字
    case "${exec_script_result}" in
        "${STOP_SERVICE_FAILED_CODE}")
            generate_stop_server_code "stop_server_failed" "${target_file}"
            ;;
        "${PACKAGE_NOT_EXIST_CODE}")
            generate_error_json "package_not_exist" "${target_file}"
            ;;
        "${NODELIST_FILE_ABNORMAL}")
            generate_error_json "nodelists_file_abnormal" "${target_file}"
            ;;
        "${GET_RESULT_FAILED_CODE}")
            generate_get_upgrade_rollback_result_code "get_result_failed" "${target_file}" "${exec_script_action}"
            ;;
        "${START_SERVICE_FAILED_CODE}")
            generate_error_json "start_server_failed" "${target_file}"
            ;;
        *)
            LOG "ERROR" "The command is invalid."
            usage
            return 1
            ;;
    esac
    return 0
}
