#!/bin/bash
ACTION={{0}}
TIMEOUT={{1}}
TASK_ID={{2}}
TOOL_PKG_DIR={{3}}
CHECK_SCRIPT={{4}}
SCRIPT_PATH=$(cd $(dirname "${0}");pwd)
START_SERVICE_TASK_ID="start_service_task_id"
ES_TASH_MGR="/opt/upgrade/easysuite_upgrade/taskmgr"
START_SERVICE_DIR="${ES_TASH_MGR}/${START_SERVICE_TASK_ID}"
EXEC_ARB_TASK="|upgrade_arb_ospatch|rollback_arb_ospatch|"
OSS_USER=$(id -nu 3001)

SELF_FILE=$(basename "${0}")
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
[ ! -d "${LOG_PATH}" ] && LOG_PATH="/opt/upgrade/os_log"
LOG_FILE="${LOG_PATH}/tool_ospatch.log"
CHECK_TASK_LOG="${LOG_PATH}/${SELF_FILE//.sh/}.log"

TASK_LOG="${ES_TASH_MGR}/${TASK_ID}/task.log"
TASK_STATUS="${ES_TASH_MGR}/${TASK_ID}/task.status"
TASK_PROGRESS="${ES_TASH_MGR}/${TASK_ID}/task.progress"
GET_RESULT_FAILED_CODE="6"

function os_restart_easysuite()
{
  echo "os_restart_easysuite"
  current_path='/opt/oss/easysuite/easysuite'
  start_sh_path=${current_path}'/start.sh'
  reboot_info_path=${current_path}'/easysuite/reboot_info.py'
  python_bin_path=${current_path}'/easysuite/3rdparty/Python39/bin/python3.9'
  bash ${start_sh_path} -r &>"$(dirname ${LOG_FILE})/es_restart.log"
}

function overtime()
{
    echo "Progress=60" >${START_SERVICE_DIR}/task.progress
    echo "Status=RUNNING" >${START_SERVICE_DIR}/task.status
    echo "[$(date +"%Y-%m-%d %H:%M:%S")] INFO | The OS restart is done." >>${START_SERVICE_DIR}/task.log

    local start_time=$(date "+%s")
    local timeout=$(expr ${start_time} + ${TIMEOUT})
    while true
    do
        sleep 3
        local current_time=$(date "+%s")
        if [ ${current_time} -ge ${timeout} ]
        then
            echo "Progress=100" >${START_SERVICE_DIR}/task.progress
            echo "Status=FAIL" >${START_SERVICE_DIR}/task.status
            echo "[$(date +"%Y-%m-%d %H:%M:%S")] ERROR | View details on the system monitoring page of the management plane." >>${START_SERVICE_DIR}/task.log
            break
        fi
        grep -i "Status=SUCCESS" ${START_SERVICE_DIR}/task.status &>/dev/null && break
    done
}

function check_ospatch()
{
    local query_result_script="/opt/upgrade/ospatch/${TOOL_PKG_DIR}/${CHECK_SCRIPT}"
    for i in $(seq 45)
    do
        bash ${query_result_script} &>>${LOG_FILE}
        local check_result=$?
        if [ ${check_result} -eq 2 ]
        then
            echo "Progress=90" >${TASK_PROGRESS}
            echo "[$(date +"%Y-%m-%d %H:%M:%S")] INFO | The OS upgrade task is running, result code:${check_result}, Please wait..." >>${TASK_LOG}
            echo "[$(date +"%Y-%m-%d %H:%M:%S")] INFO | The OS upgrade task is running, result code:${check_result}, Please wait..." >>${LOG_FILE}
            sleep 20
            continue
        fi
        if [ ${check_result} -eq 0 ]
        then
            echo "[$(date +"%Y-%m-%d %H:%M:%S")] INFO | The OS patch is successfully upgraded, Action is [${ACTION}]." >>${TASK_LOG}
            echo "[$(date +"%Y-%m-%d %H:%M:%S")] INFO | The OS patch is successfully upgraded, Action is [${ACTION}]." >>${LOG_FILE}
            echo "Progress=100" >${TASK_PROGRESS}
            echo "Status=SUCCESS" >${TASK_STATUS}
            return 0
        fi
        echo "[$(date +"%Y-%m-%d %H:%M:%S")] ERROR | Failed to upgrade the OS patch, error code:${check_result}." >>${TASK_LOG}
        echo "[$(date +"%Y-%m-%d %H:%M:%S")] ERROR | Failed to upgrade the OS patch, error code:${check_result}." >>${LOG_FILE}
        echo "[$(date +"%Y-%m-%d %H:%M:%S")] ERROR | Failed to execute the OS task, This log: ${LOG_FILE}" >>${TASK_LOG}
        echo "Progress=100" >${TASK_PROGRESS}
        echo "Status=FAIL" >${TASK_STATUS}
        return 1
    done
    generate_error_code
    echo "[$(date +"%Y-%m-%d %H:%M:%S")] ERROR | The check times out after the OS patch is upgraded, The background process may still be running. Contact R&D engineers for confirmation." >>${TASK_LOG}
    echo "[$(date +"%Y-%m-%d %H:%M:%S")] ERROR | The check times out after the OS patch is upgraded, The background process may still be running. Contact R&D engineers for confirmation." >>${LOG_FILE}
    echo "[$(date +"%Y-%m-%d %H:%M:%S")] ERROR | Failed to execute the OS task, The background process may still be running. Contact R&D engineers for confirmation. This log: ${LOG_FILE}" >>${TASK_LOG}
    echo "Progress=100" >${TASK_PROGRESS}
    echo "Status=FAIL" >${TASK_STATUS}
    return 1
}

##########################################
# 脚本失败生成错误码
##########################################
function generate_error_code() {
    source "${SCRIPT_PATH}/os_generate_error_code_util.sh"
    generate_error_code_main "${GET_RESULT_FAILED_CODE}" "${ACTION}" "${ES_TASH_MGR}/${TASK_ID}/task_error.json"
    return 0
}

function main()
{
    source $(dirname ${SCRIPT_PATH})/common.sh
    # 清理已经存在的错误码json文件
    [ -f "${ES_TASH_MGR}/${TASK_ID}/task_error.json" ] && rm -f "${ES_TASH_MGR}/${TASK_ID}/task_error.json"
    echo "${EXEC_ARB_TASK}" | grep "|${ACTION}|" &>/dev/null
    if [ $? -eq 0 ]
    then
        check_ospatch
    else
        init_taskmgr "${START_SERVICE_TASK_ID}"
        overtime & check_ospatch
    fi
    os_restart_easysuite
    rm -f ${SCRIPT_PATH}/tool_reboot_ospatch_tmp.sh
}
main