#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
if [ ! -d "${LOG_PATH}" ]; then
    mkdir -p "${LOG_PATH}"
fi
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

##################################################
# 校验执行用户
# 脚本要求使用ossadm用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

function remote_exec()
{ 
    local cmd=$1
    local omp_ip=$2
    local ssh_cmd="timeout 30 ssh -q -o ConnectTimeout=30 -o stricthostkeychecking=no ${omp_ip} "
    echo "execute ${cmd} on ${omp_ip}"  >> "${LOG_FILE}"
    local cmd_output=$(${ssh_cmd}"${cmd} 2>&1")
    echo ${cmd_output}
}

##################################################
# 容灾关联前操作
##################################################
function operate_before_build_dr()
{
    local all_omp_ips=$(cat /opt/oss/manager/var/agent/managerip.conf | grep "^managerip" | awk -F= '{print $NF}' | sed 's/,/\n/g')
    if [ ${#all_omp_ips[@]} -eq 0 ]
    then
        echo "$(date "+%Y-%m-%d %H:%M:%S") ERROR: Failed to get ip list of omp nodes." >> ${LOG_FILE} 2>&1
        return 1
    fi
    local restart_dr_cmd=". /opt/oss/manager/bin/engr_profile.sh; ipmc_adm -cmd restartapp -app DRService -tenant manager"
    for omp_ip in ${all_omp_ips[@]};do
        remote_exec "${restart_dr_cmd}" "${omp_ip}" >> ${LOG_FILE} 2>&1
    done
    sleep 60
}

function main()
{
    check_user || return 1
    operate_before_build_dr
}

main "$@"
exit $?