# -*- coding:utf-8 -*-
"""
功 能：产品运维面升级一段式升级
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import datetime
import inspect
import json
import os
import re
import shutil
import sys
import threading
import time

from commonlog import Logger
from operate_product_util import OperateProductUtil
from taskmgr_util import Taskmgrutil
from uniep_taskmgr import Unieptaskmgr

logger = Logger().getinstance(sys.argv[0])

INFO = "INFO"
WARN = "WARNING"
ERROR = "ERROR"

# 默认重试参数
DEFAULT_RETRY_TIMES = 0
DEFAULT_INTERVAL = 5
DEFAULT_OVERTIME = 3600


class TaskStatus:
    initial = "INITED"

    running = "DEPLOYING"

    error = "DEPLOY_FAILED"

    finish = "DEPLOY_SUCCESS"


class Operateproduct:
    """
    产品部署失败状态只有重试场景可以进入
    初次创建任务不支持部署失败状态直接部署产品
    """
    query_pkg_info_url = "/rest/unideploywebsite/v1/product/pkgs"
    upgrade_product_url = '/rest/plat/sysmgr/v1/main/swmgr/product/deployment'
    retry_product_url = '/rest/plat/sysmgr/v1/main/swmgr/product/deployment' \
                        '?action=retry&deploy-id=%s&product-name=%s'
    rollback_product_url = '/rest/plat/sysmgr/v1/main/swmgr/product/deployment' \
                           '?action=rollback&deploy-id=%s&product-name=%s' \
                           '&clearRedundantDB=true&startup-policy=MANUAL'
    query_deploy_status_url = '/rest/plat/sysmgr/v1/main/swmgr/product/deployment' \
                              '?product-id=%s&deploy-id=%s'
    query_deploy_msg_url = '/rest/plat/sysmgr/v1/main/swmgr/product/deployments/%s/actions'
    query_product_deploy_info_url = '/rest/plat/sysmgr/v1/main/swmgr/product?product-name=%s'
    query_product_software_params = '/rest/plat/sysmgr/v1/main/swmgr/product/productinstallinfo' \
                                    '?productname=%s&pkgs=%s'

    def __init__(self, params):
        self.operation = params.get("operation", "")
        self.productname = params.get("productname", "")
        self.src_version = params.get("src_version", "")
        self.des_version = params.get("des_version", "")
        self.confirm_second_segment = params.get("confirm_second_segment", "")
        self.task_id_path = params.get("task_id_path", "")
        self.is_protection_hot = params.get("is_protection_hot", "")
        self.single_mgr_domain = params.get("single_mgr_domain", "")
        self.upgrade_start_policy = params.get("upgrade_start_policy", "")
        self.rollback_start_policy = params.get("rollback_start_policy", "")
        self.cmd_reminder_time = int(params.get("cmd_reminder_time", 0)) * 60
        self.site = params.get("site", "")
        self.product_pkgs = params.get("product_pkgs", "")
        self.unieptask_function = Unieptaskmgr()
        self.taskmgr_function = Taskmgrutil()
        self.taskmgr_function.init_e_taskmgr(self.task_id_path)
        self.workpath = "/opt/upgrade/easysuite_upgrade/workpath/%s-%s/workpath-%s" % (
            self.src_version, self.des_version, self.productname)
        self.deploy_pkgs = []
        self.send_request_result = {}
        self.upgrade_product_status = None
        self.rollback_product_status = None
        self.thread_flag = True
        self.features = []
        self.deploy_params = []
        self.plandata_path = ""
        self.select_params_list = []
        if not os.path.isdir(self.workpath):
            os.system("mkdir -p %s" % self.workpath)
        Taskmgrutil.initial_error_path(self.workpath)
        logger.info("input:%s" % self.workpath)
        logger.info("output:%s/plandata" % self.workpath)
        logger.info("cmd reminder time:%s" % self.cmd_reminder_time)

    @staticmethod
    def get_function_name():
        """
        获取正在运行函数(或方法)名称
        :return:
        """
        return inspect.stack()[1][3]

    @staticmethod
    def get_node_id(product_name):
        """
        功能说明:获取所有产品节点的node_id
        :param product_name:
        :return:
        """
        request_function = Unieptaskmgr()
        response_list = []
        query_nodes_url = '/rest/productconfiguration/v1/nodes'
        for _ in range(0, 60):
            status, response = request_function.send_get_request(query_nodes_url)
            if status:
                response_list = json.loads(response)
                break
            time.sleep(1)
        node_ip_to_id_dict = {}
        for one_node in response_list:
            if one_node.get("productName") == product_name:
                node_ip_to_id_dict.update({one_node.get("manageIP"): one_node.get("nodeId")})
        return node_ip_to_id_dict

    def thread_scp_to_remote(self, local_file, remote_ip):
        if remote_ip.find(":") < 0:
            scp_cmd = "unset LD_LIBRARY_PATH; scp -o ConnectTimeout=300 -o stricthostkeychecking=no -o " \
                      "ConnectionAttempts=3 -o ServerAliveInterval=10 %s " \
                      "%s:/opt/oss/manager/agent/DeployAgent/etc/install/"
        else:
            scp_cmd = "unset LD_LIBRARY_PATH; scp -o ConnectTimeout=300 -o stricthostkeychecking=no -o " \
                      "ConnectionAttempts=3 -o ServerAliveInterval=10 %s " \
                      "[%s]:/opt/oss/manager/agent/DeployAgent/etc/install/"

        for try_count in range(0, 10):
            ret_code = os.system(scp_cmd % (local_file, remote_ip))
            if try_count < 9 and ret_code != 0:
                continue
            elif try_count >= 9:
                self.thread_flag = False
                logger.error("Failed to scp file to remote node.node:%s" % remote_ip)
                logger.error("node:%s scp_cmd:%s" % (remote_ip, scp_cmd))
                return False
            break
        return True

    def fresh_omp_json(self, action="fresh"):
        """
        方法说明：平台部署产品服务启动白名单中 1.加入DmqKafkaService 2.删除ERService
        返回值：无
        """
        self.print_msg(INFO, "Start to fresh default_value.json.(%s)" % self.productname)
        add_app_list = ["DmqKafkaService"]
        del_app_list = []
        omp_json_file = "/opt/oss/manager/agent/DeployAgent/etc/install/default_value.json"
        backup_omp_json = os.path.join(self.workpath, "old_default_value.json")
        new_omp_json = os.path.join(self.workpath, "default_value.json")
        if not os.path.isfile(backup_omp_json):
            logger.info("The file (%s) is not exist." % backup_omp_json)
            shutil.copy(omp_json_file, backup_omp_json)
        shutil.copy(backup_omp_json, new_omp_json)
        if action == "fresh":
            self.fresh_omp_whitelist(add_app_list, del_app_list, new_omp_json)
        ip_to_id_dict = self.get_node_id(self.productname)
        if not ip_to_id_dict:
            self.do_exist_error("Failed to fresh default_value.json.(%s)" % self.productname)
            return False
        # 并发上传文件
        child_task_threads = []
        for node_ip in ip_to_id_dict:
            child_task_threads.append(
                threading.Thread(target=self.thread_scp_to_remote, args=(new_omp_json, node_ip,)))
        for child_task_thread in child_task_threads:
            child_task_thread.start()
        for child_task_thread in child_task_threads:
            child_task_thread.join()
        if not self.thread_flag:
            self.do_exist_error("Failed to fresh default_value.json.(%s)" % self.productname)
            return False
        self.print_msg(INFO, "Finished to fresh default_value.json.(%s)" % self.productname)
        return True

    @staticmethod
    def fresh_omp_whitelist(add_app_list, del_app_list, new_omp_json):
        """
        功能说明:更新OMP服务启动白名单
        :param add_app_list:
        :param del_app_list:
        :param new_omp_json:
        :return:
        """
        with open(new_omp_json, "r") as file_obj:
            data_dict = json.load(file_obj)
            old_must_start_list = data_dict.get("mandatoryStartupServiceNamesOnUpgrading")
            logger.info("old_must_start_list:%s" % old_must_start_list)
            for one_app in add_app_list:
                if one_app not in old_must_start_list:
                    data_dict.get("mandatoryStartupServiceNamesOnUpgrading").append(one_app)
            for one_app in del_app_list:
                if one_app in old_must_start_list:
                    data_dict.get("mandatoryStartupServiceNamesOnUpgrading").remove(one_app)
        with os.fdopen(os.open(new_omp_json,
                               os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                               mode=0o660), "w", encoding="utf-8") as file_obj:
            json.dump(data_dict, file_obj, indent=4)

    def monitor_tasks(self, child_thread_tasks_data, cmd_start_time, cmd_type):

        """
        监控请求任务
        """
        # 格式化提示开始时间
        request_start_time = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(cmd_start_time))
        # 数字“57600”是“1970-01-02 00:00:00”, 只取:时分秒, 格式化时间
        request_reminder_time = time.strftime("%H:%M:%S", time.localtime(57600 + self.cmd_reminder_time))
        # 循环开关
        is_on = True
        start = time.monotonic()
        while is_on:
            time.sleep(1)
            is_on = False
            cost_time = int(time.monotonic() - start)
            for script_name, task_data in child_thread_tasks_data.items():
                request_thread = task_data.get("thread")
                request_operation = task_data.get("operation")
                request_countdown = task_data.get("countdown")
                # 线程结束,直接跳过
                if not request_thread.is_alive():
                    continue
                # 有未结束线程,打开下次循环
                is_on = True
                # 执行未超时,直接跳过,未设置超时时间跳过
                if cost_time < self.cmd_reminder_time or self.cmd_reminder_time == 0:
                    continue
                # 初始化:0,每次归0打印1次警告
                if request_countdown > 0:
                    task_data["countdown"] -= 1
                    continue
                # 重置倒计时:60
                task_data["countdown"] = 60
                # 打印1次超时提示
                warn_msg = "WARN | send request is (%s). Start Time: (%s). Cost Time: (%s)."
                if cmd_type == "IPMC":
                    warn_msg = "WARN | ipmc_tool task is (%s). Start Time: (%s). Cost Time: (%s)minutes"
                self.print_msg(WARN, warn_msg % (request_operation, request_start_time, request_reminder_time))

    def query_product_info(self):
        """
        功能描述：查询当前产品使用的param标签
        参数：无
        返回： params_dict
        修改记录：新增方法
        """
        params_dict = {}
        status, response = self.unieptask_function.send_get_request(
            self.query_product_deploy_info_url % self.productname)
        if status is False:
            return {}
        json_data = json.loads(response)
        params_dict.update({'deployId': json_data.get("entity")[0].get("deployId")})
        params_dict.update({'productId': json_data.get("entity")[0].get("productId")})
        params_dict.update({'productName': json_data.get("entity")[0].get("productName")})
        params_dict.update({'productVersion': json_data.get("entity")[0].get("productVersion")})
        params_dict.update({'features': json_data.get("entity")[0].get("features")})
        params_dict.update({'senario': json_data.get("entity")[0].get("senario")})
        params_dict.update({'parameters': json_data.get("entity")[0].get("parameters")})
        params_dict.update({'packages': json_data.get("entity")[0].get("packages")})
        params_dict.update({'deploy_status': json_data.get("entity")[0].get("status")})
        return params_dict

    def query_deploy_status(self, productid, deployid):
        """
        功能描述：查询部署进度
        参数：无
        返回： {"progress":"","status":""，"msg":""}
        修改记录：新增方法
        """
        # 产品部署状态 "INITED","DEPLOYING","DEPLOY_SUCCESS","DEPLOY_FAILED"
        status, response = self.unieptask_function.send_get_request(
            self.query_deploy_status_url % (productid, deployid))
        if status is False:
            return {"progress": "", "status": "", "msg": ""}
        res_data = json.loads(response)
        task_progrss = res_data.get("entity")[0].get("progress")
        if res_data.get("entity")[0].get("status") in [TaskStatus.finish, TaskStatus.error]:
            task_status = res_data.get("entity")[0].get("status")
        else:
            task_status = "RUNNING"
        status, response = self.unieptask_function.send_get_request(
            self.query_deploy_msg_url % deployid)
        if status is False:
            return {"progress": "", "status": "", "msg": ""}
        task_msg = str(response, encoding="utf-8")
        return {"progress": task_progrss, "status": task_status, "msg": task_msg}

    @staticmethod
    def gen_upgrade_params(param_dict, target_version, packages):
        # sysProperties：部署控制配置项，properties：业务配置项
        upgrade_params = {}
        upgrade_params.update({'productName': param_dict.get("productName")})
        upgrade_params.update({'productId': param_dict.get("productId")})
        upgrade_params.update({'productVersion': target_version})
        upgrade_params.update({'scenario': param_dict.get("senario", 'all')})
        upgrade_params.update({'featureList': param_dict.get("features")})
        upgrade_params.update({'parameters': param_dict.get("parameters")})
        upgrade_params.update({'deployType': 'UPGRADE'})
        upgrade_params.update({'startupPolicy': 'MANUAL'})
        upgrade_params.update({'packages': packages})
        return upgrade_params

    def query_firstphase_result(self, deploy_id):
        status, response = self.unieptask_function.send_get_request(
            self.query_deploy_msg_url % deploy_id)
        if status is False:
            self.do_exist_error(
                "Failed to send upgrade request(%s) to manager." % self.query_deploy_msg_url % (
                    self.productname))
            return False
        response_decode = response.decode().strip()
        first_step_finish = response_decode.endswith("The first phase of the upgrade is complete.")
        if first_step_finish:
            return True
        logger.info(f"response_content:{response_decode}")
        logger.info(f"first_step_finish:{first_step_finish}")
        return False

    def check_first_phase_finish(self, deploy_id, task_path):
        ret_result = self.query_firstphase_result(deploy_id)
        if ret_result:
            self.print_msg(INFO,
                           "The first phase of the upgrade is complete.(%s)" % self.productname)
            self.set_task_data("success", "100")
            return True
        return False

    def wait_product_task(self, url_response, product_id, deploy_id, task_path,
                          first_phase=False):
        # 根据response获取deployid
        # 2.下发失败报错退出
        task_status = json.loads(url_response).get("result").lower()
        if task_status == "failed":
            self.print_msg("info", json.loads(url_response).get("message"))
            self.set_task_data("error", "100")
            return False
        old_msg_file_path = os.path.join(task_path, "task.log")
        if os.path.isfile(old_msg_file_path):
            __task_msg = Taskmgrutil.read_linux_file(old_msg_file_path)
        else:
            __task_msg = ""
        while True:
            # 查询产品部署状态不断刷新状态文件
            deploy_task_info = self.query_deploy_status(product_id, deploy_id)
            deploy_task_msg = deploy_task_info.get("msg")
            if not __task_msg:
                Taskmgrutil.set_msg_overwrite(task_path, deploy_task_msg)
            else:
                Taskmgrutil.set_msg_overwrite(task_path, "%s\n%s" % (__task_msg, deploy_task_msg))

            # 部署失败退出，失败时，平台进度不会到100
            deploy_task_status = deploy_task_info.get("status", TaskStatus.running)
            deploy_task_progress = deploy_task_info.get("progress", "0")
            logger.info(f"[wait_product_task] deploy task status: {deploy_task_status}, "
                        f"progress: {deploy_task_progress}")
            if deploy_task_status == TaskStatus.error:
                self.set_task_data("error", "100")
                break
            if deploy_task_status == TaskStatus.finish:
                target_version = self.src_version
                if self.operation == 'upgrade':
                    target_version = self.des_version
                if not OperateProductUtil.modify_product_version(self.productname,
                                                                 target_version):
                    self.set_task_data("error", "100")
                    break
                self.set_task_data("success", "100")
                break
            time.sleep(5)
            self.set_task_data(deploy_task_status, deploy_task_progress)
            if first_phase and self.check_first_phase_finish(deploy_id, task_path):
                break
        return True

    def print_msg(self, level, msg, form=""):
        now_time = datetime.datetime.strftime(datetime.datetime.now(), '%Y-%m-%d %H:%M:%S')
        if level in ["info", "warn", "error"]:
            level = level.upper()
        str_msg = "[%s] %s" % (now_time, msg)
        if form == "script_output":
            str_msg = msg
        elif level == "ERROR":
            str_msg = "[%s] [%s] %s\n" % (now_time, level, msg)
        Taskmgrutil.set_msg_append(self.task_id_path, str_msg)
        logger.info(str_msg)
        return True

    def get_product_info(self):
        """
        调用平台查询产品信息接口获取产品信息
        """
        os.chmod(self.workpath, 0o700)
        for _ in range(0, 2):
            retcode = os.system("bash /opt/oss/manager/tools/resmgr/queryproduct.sh -pn %s -output "
                                "%s" % (self.productname, self.workpath))
            if retcode == 0:
                break
            else:
                time.sleep(1)
        if retcode != 0:
            logger.info("[%s] Result:%s" % (self.get_function_name(), retcode))
            return False
        return True

    def script_thread(self, script, script_info, script_retry_info):
        error_path = Taskmgrutil.error_path(self.workpath)
        error_code_file = script.split("/")[-1] + ".json"
        error_code_file_path = os.path.join(error_path, error_code_file)
        cmd = f"bash {script} -input {self.workpath} -output {self.plandata_path} -error_path {error_path}"
        ret_code, ret_msg = Taskmgrutil.execute_cmd(cmd)
        if ret_msg.strip():
            self.print_msg(INFO, ret_msg.strip(), form='script_output')
        if ret_code == 0:
            logger.info("[%s] script: %s Result:%s Msg:%s" % (self.get_function_name(), script,
                                                              ret_code, ret_msg))
        # 脚本返回非0，判断是否重试
        if ret_code != 0:
            logger.error("[%s] script: %s Result:%s Msg:%s" % (self.get_function_name(), script,
                                                               ret_code, ret_msg))
            # 解析错误码(无错误码直接报错)
            error_code = self.query_script_error_code(error_code_file_path)
            if not error_code:
                return False

            # 根据错误码匹配重试配置（未配置的错误码不处理）
            if error_code not in script_retry_info.keys():
                return False

            # 执行重试
            retry_times = script_retry_info.get(error_code).get("retry_times", DEFAULT_RETRY_TIMES)
            interval = script_retry_info.get(error_code).get("interval", DEFAULT_INTERVAL)
            overtime = script_retry_info.get(error_code).get("overtime", DEFAULT_OVERTIME)
            if not retry_times:
                return False
            for i in range(retry_times):
                time.sleep(interval)
                self.print_msg(INFO, f"Start to retry script{script_info} for time {i + 1}, Max retry time: "
                                     f"{retry_times}, Code: {error_code}, Interval: {interval}s, Overtime: {overtime}s")

                # 清理历史错误码文件
                if os.path.isfile(error_code_file_path):
                    os.remove(error_code_file_path)

                ret_code, ret_msg = Taskmgrutil.execute_cmd(cmd, timeout=overtime)
                if ret_code == 0:
                    return True

                self.print_msg(INFO, "Script: %s Result:%s\nMsg:%s" % (script, ret_code, ret_msg))
                logger.error("[%s] script: %s Result:%s Msg:%s" % (self.get_function_name(), script,
                                                                   ret_code, ret_msg))
                continue
            return False
        return True

    def run_domain_cmd(self):
        """
        功能描述：调用子域脚本获取配置信息
        """
        pyscript_path = sys.path[0]
        if os.path.isdir(self.plandata_path):
            os.system("cd %s && ls | grep -v 'containerlist_old.json' | xargs rm -rf "
                      % self.plandata_path)
        os.system("mkdir -p %s" % self.plandata_path)
        domain_path = os.path.join(pyscript_path, "..", "..", "..")
        self.print_msg(INFO, "Start to get domain config.")
        for domain in os.listdir(domain_path):
            if domain == "common":
                domain_script_path = os.path.join(domain_path, domain, "NCE-Common")
            else:
                domain_script_path = os.path.join(domain_path, domain)
            if not os.path.isdir(domain_script_path):
                continue
            # 解析子域脚本重试配置
            scripts_retry_config = self.parse_domain_retry_config(domain_script_path)
            for filename in os.listdir(domain_script_path):
                if not filename.startswith("plandata_custom_") or not filename.endswith(".sh"):
                    continue
                script_name = os.path.join(domain_script_path, filename)
                script_retry_info = scripts_retry_config.get(filename, {}).get("error_code", {})
                script_info = f"({filename})[solution due to {domain}]"
                self.print_msg(INFO, f"Start to run script{script_info}.")
                if not self.script_thread(script_name, script_info, script_retry_info):
                    self.print_msg(INFO, f"Failed to run script{script_info}.")
                    return False
                self.print_msg(INFO, f"Finished to run script{script_info}.")
        self.print_msg(INFO, "Finished to get domain config.")
        return True

    def parse_domain_retry_config(self, domain_script_path):
        """
        解析子域脚本重试配置
        """
        # 解析对应领域配置的自动重试信息
        domain_retry_config_file = os.path.join(domain_script_path, "auto_retry.json")
        if not os.path.isfile(domain_retry_config_file):
            return {}
        with open(domain_retry_config_file, "r") as f:
            retry_config = json.loads(f.read())
        if not isinstance(retry_config, dict):
            return {}
        scripts_retry_config = retry_config.get("scripts", {})
        return scripts_retry_config

    def query_script_error_code(self, error_code_file_path):
        """
        查询脚本返回错误码
        """
        if not os.path.isfile(error_code_file_path):
            return ""
        with open(error_code_file_path, "r") as f:
            error_info = json.loads(f.read())
        error_code = error_info.get("error_code", "")
        return error_code

    def get_product_features(self):
        product_json = os.path.join(self.workpath, "product_%s.json" % self.productname)
        with open(product_json, "r") as file_obj:
            product_data = json.load(file_obj)
            features = product_data.get("productext").get("features").split(";")
        # 遍历所有feature_plan_domain.json
        new_feature_list = []
        add_feature = []
        del_feature = []
        for filename in os.listdir(os.path.join(self.workpath, "plandata")):
            filepath = os.path.join(self.workpath, "plandata", filename)
            if os.path.isfile(filepath) and filename.startswith("feature_plan_") and \
                    filename.endswith(".json"):
                with open(filepath, "r") as file_obj:
                    file_data = json.load(file_obj)
                    add_feature = add_feature + file_data.get("feature").get("addFeatures", [])
                    del_feature = del_feature + file_data.get("feature").get("delFeatures", [])
        add_feature = list(set(add_feature))
        del_feature = list(set(del_feature))
        self.print_msg(INFO, "Add_feature:%s" % add_feature)
        self.print_msg(INFO, "Del_feature:%s" % del_feature)
        for one_feature in features:
            if one_feature != "" and one_feature not in del_feature:
                new_feature_list.append(one_feature)
        new_feature_list = new_feature_list + add_feature
        self.features = list(set(new_feature_list))
        self.print_msg(INFO, "Deploy_feature:%s" % self.features)
        return True

    def add_node_tag(self, nodetag_list, tag_list):
        deal_list = nodetag_list
        for one_tag in tag_list:
            real_tag = one_tag.replace("{regionAlias}", self.productname)
            if real_tag in nodetag_list:
                continue
            else:
                deal_list.append(real_tag)
        return deal_list

    def del_node_tag(self, nodetag_list, tag_list):
        deal_list = nodetag_list
        for one_tag in tag_list:
            real_tag = one_tag.replace("{regionAlias}", self.productname)
            if real_tag not in nodetag_list:
                continue
            else:
                deal_list.remove(real_tag)
        return deal_list

    def dest_node_tag(self, nodetag_list, tag_list):
        deal_list = nodetag_list
        for one_tag in nodetag_list[::-1]:
            if one_tag.find(self.productname) >= 0:
                deal_list.remove(one_tag)
        for dest_tag in tag_list:
            real_tag = dest_tag.replace("{regionAlias}", self.productname)
            deal_list.append(real_tag)
        return deal_list

    def get_node_tags(self):
        # 遍历所有node_plan_domain.json
        node_list = []
        for filename in os.listdir(os.path.join(self.workpath, "plandata")):
            filepath = os.path.join(self.workpath, "plandata", filename)
            if os.path.isfile(filepath) and filename.startswith("node_plan_") and \
                    filename.endswith(".json"):
                with open(filepath, "r") as file_obj:
                    file_data = json.load(file_obj)
                    node_list = node_list + file_data.get("node")
        nodes_json = os.path.join(self.workpath, "nodes_%s.json" % self.productname)
        node_data = {}
        with open(nodes_json, "r") as file_obj:
            nodes_data = json.load(file_obj)
            for one_node in nodes_data.get("hostlist"):
                node_data.update({one_node.get("nodename"): one_node.get("nodeext").get("nodetag")})
        deal_node_data = {}
        for one_node in node_data:
            nodetag_list = node_data.get(one_node).split(",")
            nodetag_list = self.fresh_node_tags(node_list, nodetag_list, one_node)
            deal_node_data.update({one_node: nodetag_list})
        new_nodes_data = {}
        new_node_list = []
        for one_node in nodes_data.get("hostlist"):
            nodeext = {}
            nodeext.update(one_node.get("nodeext"))
            new_nodetag = ",".join(deal_node_data.get(one_node.get("nodename")))
            nodeext.update({"nodetag": new_nodetag})
            new_node = {}
            new_node.update(one_node)
            new_node.update({"nodeext": nodeext})
            new_node_list.append(new_node)
        new_nodes_data.update(nodes_data)
        new_nodes_data.update({"hostlist": new_node_list})
        old_nodes_json = os.path.join(self.workpath, "plandata", "old_nodes_%s.json" %
                                      self.productname)
        os.system("cp -fp %s %s" % (nodes_json, old_nodes_json))
        new_nodes_json = os.path.join(self.workpath, "plandata", "new_nodes_%s.json" %
                                      self.productname)
        with os.fdopen(os.open(new_nodes_json,
                               os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                               mode=0o660), "w", encoding="utf-8") as file_obj:
            json.dump(new_nodes_data, file_obj)
        return True

    def fresh_node_tags(self, node_list, nodetag_list, one_node):
        for domain_one_node in node_list:
            if domain_one_node.get("nodeName") != one_node:
                continue
            if domain_one_node.get("addTags", []):
                self.print_msg(INFO, "Nodename:%s addTags:%s" % (
                    one_node, ",".join(domain_one_node.get("addTags", []))))
                nodetag_list = self.add_node_tag(nodetag_list, domain_one_node.get(
                    "addTags", []))
            if domain_one_node.get("delTags", []):
                self.print_msg(INFO, "Nodename:%s delTags:%s" % (
                    one_node, ",".join(domain_one_node.get("delTags", []))))
                nodetag_list = self.del_node_tag(nodetag_list,
                                                 domain_one_node.get("delTags", []))
            if domain_one_node.get("destTags", []):
                self.print_msg(INFO, "Nodename:%s destTags:%s" % (
                    one_node, ",".join(domain_one_node.get("destTags", []))))
                nodetag_list = self.dest_node_tag(nodetag_list,
                                                  domain_one_node.get("destTags", []))
        return nodetag_list

    def query_product_new_params(self, select_features_list, old_param_name_list):
        """
        功能描述：准备升级需要的参数
        参数：select_features_list：升级选择的特性列表，old_param_name_list：旧版本的参数列表
        返回： new_params_dict：{新增可支持修改的参数名：新参数列表中的位置}，all_params：升级的参数列表
        修改记录：新增方法
        """
        pkgs_param = []
        for pkg in self.deploy_pkgs:
            pkgs_param.append("%s-%s" % (pkg.get("name"), pkg.get("version")))
        pkgs = ",".join(pkgs_param)
        # 调用此接口，请使用old_deploy_params内的value覆盖查询出来的参数值，"type": "encrypt"时，返回的是****而非密文
        status, response = self.unieptask_function.send_get_request(
            self.query_product_software_params % (self.productname, pkgs))
        if not status:
            return "", ""
        try:
            query = json.loads(response)
        except Exception as e_msg:
            logger.error("Failed to json.loads(%s).Exception:%s" % (response, e_msg))
            return "", ""
        new_params = query.get("InstallParameters")
        all_features = []
        for feature_group in query.get("featureGroupList"):
            if feature_group.get("name") == self.query_product_info().get("senario"):
                all_features = feature_group.get("features")
                break
        select_params_list = []
        new_params_dict = {}
        all_params = []
        for feature in all_features:
            if feature.get("name") not in select_features_list:
                continue
            select_params_list.extend(feature.get("paratemers"))
        select_params_list = list(set(select_params_list))
        for param in select_params_list:
            if param in old_param_name_list:
                continue
            new_params_dict.update({param: select_params_list.index(param)})
        for i in select_params_list:
            for param in new_params:
                if i != param.get("name"):
                    continue
                all_params.append(param)
        self.select_params_list = select_params_list
        logger.info(
            "select_features_list len:%s;%s" % (len(select_features_list), select_features_list))
        logger.info("select_params_list len:%s;%s" % (len(select_params_list), select_params_list))
        logger.info("new_params_dict len:%s;%s" % (len(new_params_dict), new_params_dict))
        logger.info("original_all_params len:%s" % len(all_params))
        return new_params_dict, all_params

    @staticmethod
    def update_old_params_value(params, name, value):
        """
        功能说明:更新旧的部署参数
        :param params
        :param name
        :param value
        """
        if not isinstance(params, list):
            return
        for param_index in range(len(params)):
            if params[param_index].get("name") == name:
                params[param_index].update({'value': value})

    def get_deploy_params(self):
        old_deploy_params = self.query_product_info().get("parameters")
        # 遍历所有param_plan_domain.json文件
        add_params = []
        for filename in os.listdir(os.path.join(self.workpath, "plandata")):
            filepath = os.path.join(self.workpath, "plandata", filename)
            if os.path.isfile(filepath) and filename.startswith("param_plan_") and \
                    filename.endswith(".json"):
                with open(filepath, "r") as file_obj:
                    file_data = json.load(file_obj)
                    add_params = add_params + file_data.get("addParams")
        old_param_name_list = []
        for one_param in old_deploy_params:
            old_param_name_list.append(one_param.get("name"))
        logger.info("old_deploy_params_list:%s" % old_param_name_list)
        new_param_dict, all_params = self.query_product_new_params(self.features,
                                                                   old_param_name_list)
        if new_param_dict == "" and all_params == "":
            return False
        # 使用旧参数覆盖新参数相同name的value
        old_param_name_dict = {}
        for old in old_deploy_params:
            old_param_name_dict[old.get("name")] = old.get("value")
        for one in all_params:
            temp_name = one.get("name")
            if temp_name in old_param_name_dict.keys():
                old_value = old_param_name_dict.get(temp_name)
                one.update({"value": old_value})
        del_param_list = []
        for i in old_param_name_list:
            if i in self.select_params_list:
                continue
            del_param_list.append(i)
        logger.info("del_param_list len:%s;%s" % (len(del_param_list), del_param_list))
        for new_param in add_params:
            # 旧版本被删除的参数直接跳过
            if new_param.get("name") in del_param_list:
                continue
            # 相对于旧版本新增的参数支持修改
            if new_param.get("name") in new_param_dict.keys():
                self.update_old_deploy_params(all_params, new_param, new_param_dict)
                continue
            # 原来没有的参数支持新增，原来有的参数不支持修改
            if new_param.get("name") not in self.select_params_list:
                self.add_new_params(all_params, new_param)
                continue
            Operateproduct.update_old_params_value(all_params, new_param.get("name"),
                                                   new_param.get("value"))
        logger.info("all_params len:%s" % len(all_params))
        self.deploy_params = all_params
        return True

    @staticmethod
    def add_new_params(all_params, new_param):
        """
        功能说明:新增部署参数
        :param all_params:
        :param new_param:
        :return:
        """
        param_modle = {}
        param_modle.update(all_params[0])
        param_modle.update({"name": new_param.get("name")})
        param_modle.update({"value": new_param.get("value")})
        param_modle.update({"desc": new_param.get("desc", '')})
        param_modle.update({"type": new_param.get("type", 'string')})
        param_modle.update({"pattern": new_param.get("pattern", '')})
        param_modle.update({"range": new_param.get("range", '')})
        param_modle.update({"required": new_param.get("required", 'false')})
        param_modle.update({"invisible": new_param.get("invisible", 'false')})
        param_modle.update({"readonly": new_param.get("readonly", 'false')})
        res_model = {}
        res_model.update({"key": new_param.get("name")})
        res_model.update({"zh_CN": new_param.get("name")})
        res_model.update({"en_US": new_param.get("name")})
        res_model.update({"description": {'zh_CN': '', 'en_US': ''}})
        param_modle.update({'resources': res_model})
        all_params.append(param_modle)
        logger.info("new_param_name:%s" % param_modle.get('name', ''))

    @staticmethod
    def update_old_deploy_params(all_params, new_param, new_param_dict):
        """
        功能说明:更新旧的部署参数
        :param all_params:
        :param new_param:
        :param new_param_dict:
        :return:
        """
        for original_param in all_params:
            if original_param.get("name") != new_param.get("name"):
                continue
            index = new_param_dict.get(new_param.get("name"))
            original_param.update({"value": new_param.get("value")})
            logger.info("modify_param_name:%s" % original_param.get("name"))
            all_params[index] = original_param

    def get_deploy_pkgs(self, offline_pkgs):
        """
        获取当前产品部署的所有包列表
        """
        status, response = self.unieptask_function.send_get_request(self.query_pkg_info_url)
        if status is False:
            return False
        # 管理面软件仓库中的包
        pub_pkgs = json.loads(response).get("entity")
        # 升级新增的产品软件包
        add_product_pkgs = self.product_pkgs.split(",")
        # 已部署的产品软件包
        current_pkgs = self.query_product_info().get("packages")

        # 产品部署需要的全部包
        pkgs_list = []

        # 软件仓库新增用来升级的包
        new_pub_pkgs = []
        # 提取关键字段，和current_pkgs结构一致
        for one_pub_pkg in pub_pkgs:
            if one_pub_pkg.get("packageName") in add_product_pkgs:
                new_pub_pkgs.append({"name": one_pub_pkg.get("softwareName"),
                                     "version": one_pub_pkg.get("softwareVersion"),
                                     "packageType": one_pub_pkg.get("releaseType")})

        # 升级新增的全量包
        for one_pub_pkg in new_pub_pkgs:
            if one_pub_pkg.get("packageType").lower() == "full":
                pkgs_list.append(one_pub_pkg)

        # 基础版本保留的全量包
        pkg_names_list = [one_pkg.get("name") for one_pkg in pkgs_list]
        for one_current_pkg in current_pkgs:
            if one_current_pkg.get("name") not in pkg_names_list:
                pkgs_list.append(one_current_pkg)

        # 升级基于所有全量包新增的补丁包
        pkg_names_list = [one_pkg.get("name") for one_pkg in pkgs_list]

        for one_pub_pkg in new_pub_pkgs:
            if one_pub_pkg.get("packageType").lower() != "full" and one_pub_pkg.get("name") in pkg_names_list:
                pkgs_list.append(one_pub_pkg)

        # 下架部分软件包
        ret_pkgs_list = []
        offline_pkg_list = offline_pkgs.split(",")
        for pkg in pkgs_list:
            if pkg in ret_pkgs_list:
                continue
            is_append_flag = True
            for off_pkg_name in offline_pkg_list:
                if off_pkg_name == "":
                    continue
                if off_pkg_name.upper() == pkg.get("name", "").upper():
                    is_append_flag = False
                    break
            if is_append_flag:
                ret_pkgs_list.append(pkg)
        self.deploy_pkgs = ret_pkgs_list
        logger.info("Upgrade deploy_pkgs:%s" % self.deploy_pkgs)
        return True

    def get_domain_config(self, offline_pkgs):
        self.get_product_info()
        self.plandata_path = os.path.join(self.workpath, "plandata")
        result = self.run_domain_cmd()
        if not result:
            return False
        self.get_product_features()
        self.get_node_tags()
        self.get_deploy_pkgs(offline_pkgs)
        if not self.get_deploy_params():
            return False
        return True

    def retry_product(self, task_id_path):
        """
        功能说明:重试升级&回滚部署任务
        :param task_id_path:
        :return:
        """
        product_info = self.query_product_info()

        # 对product_info执行浅拷贝, 删除敏感信息parameters后打印日志
        product_info_output = product_info.copy()
        if product_info_output.get('parameters', ''):
            product_info_output.pop('parameters')
        logger.info(f"The product info is {product_info_output}")

        product_deployid = product_info.get("deployId")
        product_id = product_info.get("productId")
        logger.info("[function_name:%s] product_deployid:%s" % (self.get_function_name(),
                                                                product_deployid))
        deploy_status = product_info.get("deploy_status")
        logger.info(f"The task status is {deploy_status}")
        if deploy_status == TaskStatus.error:
            logger.info(f"Retry the failed task.")
            status, response = self.unieptask_function.send_put_request(
                self.retry_product_url % (product_deployid, self.productname))
            if status is False:
                return 1
            # 根据response获取deployid
            deploy_id = json.loads(response).get("entity")[0].get("deployId")
            logger.info("[function_name:%s] product_deployid:%s" % (
                self.get_function_name(), product_deployid))
            # 查询进度等待任务执行完成
            self.wait_product_task(response, product_id, deploy_id, task_id_path)
            return 0
        if deploy_status == TaskStatus.running:
            logger.info(f"Resume the running task.")
            self.print_msg(INFO, f"Resume the previous running task:")
            task_info = {
                "result": "running"
            }
            self.wait_product_task(json.dumps(task_info), product_id, product_deployid, task_id_path)
            return 0
        return 2

    def do_exist_error(self, msg):
        """
        功能说明:失败退出
        :param msg:
        :return:
        """
        self.print_msg(INFO, msg)
        self.set_task_data("error", "100")

    def ipmc_tool_upgrade_product(self, upgrade_data, task_detail, work_path):
        """
        封装ipmc_tool_upgrade_product调用方法
        """
        status, is_deploy_task_created= OperateProductUtil.ipmc_tool_upgrade_product(upgrade_data, task_detail, work_path)
        # 部署任务创建后，记录产品名和deploy_id
        if is_deploy_task_created:
            self.generate_deploy_record(work_path)
        if status is False:
            self.upgrade_product_status = False
            return self.upgrade_product_status
        self.upgrade_product_status = True
        return self.upgrade_product_status

    def generate_deploy_record(self, work_path):
        params_dict = self.query_product_info()
        product_id = params_dict.get('productId', str())
        rollback_deploy_id = self.get_rollback_id(product_id)
        deploy_id = params_dict.get("deployId")
        rollback_check_json = os.path.join(work_path, "rollback_check.json")
        input_data = {
            "productName": self.productname,
            "deployId": deploy_id,
            "rollback_deploy_id": rollback_deploy_id,
            "product_id": product_id
        }
        with open(rollback_check_json, "w", encoding="utf-8") as file:
            file.write(json.dumps(input_data))
        logger.info(f"Generate rollback_check.json for deploy task, file path: {work_path}")

    def pre_upgrade_product(self, params_dict, upgrade_deploy_data, task_id_path):
        """
        功能说明:升级升级前置处理:1.检查是否已升级至目标版本 2. 保存升级前配置数据 3.导入节点新的规划数据
        :param params_dict:
        :param upgrade_deploy_data:
        :param task_id_path:
        :return: True, False, None
        """
        if OperateProductUtil.is_already_upgrade(params_dict, upgrade_deploy_data):
            self.print_msg(INFO, "The upgrade_targetversion is same with the "
                                 "product_currentversion.Skip this step.")
            self.set_task_data("success", "100")
            return True, ""

        if not OperateProductUtil.save_pre_upgrade_config(params_dict, self.plandata_path):
            logger.error("OperateProductUtil.save_pre_upgrade_config,Result:False")
            return False, ""

        # 导入新的nodes_*.json
        ret_code = os.system("bash /opt/oss/manager/tools/resmgr/modifynodesinfo.sh -input "
                             "%s/new_nodes_%s.json" % (self.plandata_path, self.productname))
        if ret_code != 0:
            self.do_exist_error("Failed to refresh new_nodes_%s.json." % self.productname)
            return False, ""

        return True, "continue"

    def upgrade_product(self, target_version, task_id_path, product_pkgs, offline_pkgs,
                        upgrade_start_policy, parallel_installation):
        """
        功能描述：升级产品
        参数：无
        返回： params_list
        修改记录：新增方法
        """
        self.product_pkgs = product_pkgs
        __taskmsg = os.path.join(task_id_path, "task.log")
        ret_code = self.retry_product(task_id_path)
        if ret_code == 0:
            return True
        elif ret_code == 1:
            return False
        # 查询产品信息
        params_dict = self.query_product_info()

        # 执行子域定制脚本
        result = self.get_domain_config(offline_pkgs)
        if not result:
            self.do_exist_error("Failed to get domain config.")
            return False
        # 导入新的nodes_*.json
        params_dict.update({"parameters": self.deploy_params})
        params_dict.update({"features": self.features})
        params_dict.update({"upgrade_start_policy": upgrade_start_policy})
        params_dict.update({"parallelInstallation": parallel_installation})
        __upgrade_data = OperateProductUtil.build_upgrade_data(params_dict, target_version,
                                                               self.deploy_pkgs)
        upgrade_deploy_data = {"target_version": target_version}
        upgrade_deploy_data.update({"packages": self.deploy_pkgs})

        result, msg = self.pre_upgrade_product(params_dict, upgrade_deploy_data, task_id_path)
        if not msg and result in [True, False]:
            return result

        # ipmc_tool调用方式
        # 记录开始时间
        ipmc_tool_start_time = time.time()
        # 创建并启动任务线程
        ipmc_tool_thread = threading.Thread(target=self.ipmc_tool_upgrade_product,
                                            args=(__upgrade_data, __taskmsg, self.plandata_path),
                                            name="child-thread-0")
        ipmc_tool_thread.start()
        # 收集任务信息
        ipmc_tool_thread_tasks_data = {
            "upgrade_product": {"thread": ipmc_tool_thread, "operation": "Upgrade Product", "countdown": 0}}
        # 监控任务进度
        self.monitor_tasks(ipmc_tool_thread_tasks_data, ipmc_tool_start_time, "IPMC")
        if not self.upgrade_product_status:
            time.sleep(5)
            self.set_task_data("error", "100")
            return False
        self.set_task_data("finish", "100")
        return True

    def set_task_data(self, status, progress=""):
        """
        功能说明:设置任务状态
        :param status:
        :param progress:
        :return:
        """
        Taskmgrutil.set_e_taskstatus(self.task_id_path, status.lower())
        if status.lower() in ["finish", "error", "success", "failed"]:
            # 任务处理结束态汇总失败详情
            Taskmgrutil.set_task_error_details(self.task_id_path,
                                               [Taskmgrutil.error_path(self.workpath)])
        if progress:
            Taskmgrutil.set_e_taskprogress(self.task_id_path, progress)


    @staticmethod
    def get_deploy_id(seqnum, deploy_data):
        for one_deploy_data in deploy_data:
            if seqnum == one_deploy_data.get("seqNo"):
                return one_deploy_data.get("deployId")
        return None

    @staticmethod
    def logger_list(in_list):
        count = 0
        for one in in_list:
            logger.info("print list order:%s obj:%s" % (count, one))
            count = count + 1
        return True

    @staticmethod
    def del_rollback_history(rollback_seq_num, seq_num, deploy_history_list):
        ret_deploy_history_list = []
        for one_deploy_history in deploy_history_list:
            if int(rollback_seq_num) >= int(one_deploy_history.get("seqNo")) > int(seq_num):
                continue
            ret_deploy_history_list.append(one_deploy_history)
        return ret_deploy_history_list

    @staticmethod
    def get_rollback_id(product_id):
        """
        功能描述：根据现有部署历史获取回滚
        参数：无
        返回： params_list
        修改记录：新增方法
        """
        # 其中失败直接跳过
        # "seqNo":"","deployid":"","deployDesc":"","deployType":""
        # 部署失败状态是否能够回滚
        # 最近一次状态，部署成功状态
        # 1.升级 直接返回最近一次的前一次的deploy-id
        # 2.回退 对应回退的seqNo再往前一位
        query_product_url = f"/rest/plat/sysmgr/v1/main/swmgr/product/" \
                            f"deployment?product-id={product_id}"
        status, response = Unieptaskmgr().send_get_request(query_product_url)
        if status is False:
            return ""
        product_deploy_history_list = json.loads(response).get("entity")
        # 计算过程需要记录日志
        # 1.解析过滤回滚失败记录，回滚失败等于没有回滚，回滚失败会基于失败任务执行重试
        # 2.升级失败存在选择是否新建任务重试场景，如果用户选择了新建任务重试seqnum会+1
        # 找出新建任务重试场景的seqnum，将它过滤掉以免干扰后面判断
        success_deploy_history_list = []
        for one_deploy_history in product_deploy_history_list:
            new_deploy_history = {}
            new_deploy_history.update({"deployDesc": one_deploy_history.get("deployDesc")})
            new_deploy_history.update({"deployType": one_deploy_history.get("deployType")})
            new_deploy_history.update({"deployId": one_deploy_history.get("deployId")})
            new_deploy_history.update({"status": one_deploy_history.get("status")})
            new_deploy_history.update({"seqNo": one_deploy_history.get("seqNo")})
            if one_deploy_history.get("deployType") == "ROLLBACK" \
                    and one_deploy_history.get("status") == TaskStatus.error:
                continue
            success_deploy_history_list.append(new_deploy_history)
        success_deploy_history_list.reverse()
        # 过滤掉无关任务
        # 得出任务中必然没有rollback任务和回滚掉了的升级任务
        # 只有升级任务
        without_rollback_list = success_deploy_history_list
        for one_deploy_history in success_deploy_history_list:
            if one_deploy_history.get("deployType") == "ROLLBACK":
                rollback_seq_num = one_deploy_history.get("seqNo")
                seq_num = re.sub("[^0-9]", "",
                                 one_deploy_history.get("deployDesc"))
                without_rollback_list = Operateproduct.del_rollback_history(rollback_seq_num,
                                                                            seq_num,
                                                                            without_rollback_list)
        Operateproduct.logger_list(without_rollback_list)
        rollback_id = without_rollback_list[-2].get("deployId")
        return rollback_id

    def rollback_retry_product(self, product_id):
        status, response = self.unieptask_function.send_get_request(
            "%s?product-id=%s" % (self.upgrade_product_url, product_id))
        if status is False:
            self.do_exist_error("Failed to send request")
            return False
        product_deploy_history_list = json.loads(response).get("entity")
        last_deploy_history_type = product_deploy_history_list[0].get("deployType")
        last_deploy_history_status = product_deploy_history_list[0].get("status")
        if last_deploy_history_type == "ROLLBACK" and last_deploy_history_status == \
                TaskStatus.error:
            self.retry_product(self.task_id_path)
            return False
        return True

    def rollback_product(self, task_id_path, source_version, params):
        """
        功能描述：回滚产品
        参数：无
        返回： params_list
        修改记录：新增方法
        """
        params_dict = self.query_product_info()
        product_id = params_dict.get("productId")
        __taskmsg = os.path.join(task_id_path, "task.log")
        if not self.rollback_retry_product(product_id):
            return False
        if OperateProductUtil.is_already_rollback(params_dict,
                                                  os.path.join(self.workpath, "plandata"),
                                                  source_version):
            self.print_msg(INFO, "The upgrade_targetversion is same with the "
                                 "product_currentversion.Skip this step.")
            self.set_task_data("success", "100")
            return True
        rollback_id = self.get_rollback_id(product_id)
        if rollback_id == "":
            self.do_exist_error("Failed to send request")
            return False
        # 导入旧的nodes_*.json
        self.plandata_path = os.path.join(self.workpath, "plandata")
        retcode = os.system("bash /opt/oss/manager/tools/resmgr/modifynodesinfo.sh -input "
                            "%s/old_nodes_%s.json" % (self.plandata_path, self.productname))
        if retcode != 0:
            rep_script = "${REPLACE_PATH}/manager/tools/resmgr/modifynodesinfo.sh"
            self.do_exist_error("Failed to run script(%s)" % rep_script)
            return False
        # ipmc_tool调用方式
        # 记录开始时间
        ipmc_tool_start_time = time.time()
        # 创建并启动任务线程
        ipmc_tool_thread = threading.Thread(target=self.ipmc_tool_rollback_product, args=(
            rollback_id, self.productname, __taskmsg, self.plandata_path,
            source_version, ), kwargs=params, name="child-thread-0")
        ipmc_tool_thread.start()
        # 收集任务信息
        ipmc_tool_thread_tasks_data = {
            "rollback_product": {"thread": ipmc_tool_thread, "operation": "Rollback Product", "countdown": 0}}
        # 监控任务进度
        self.monitor_tasks(ipmc_tool_thread_tasks_data, ipmc_tool_start_time, "IPMC")
        if not self.rollback_product_status:
            time.sleep(5)
            self.set_task_data("error", "100")
            return False
        self.set_task_data("success", "100")
        return True

    def ipmc_tool_rollback_product(self, deploy_id, product_name,
                                   task_detail, work_path, target_version, **kwargs):
        """
        封装ipmc_tool_rollback_product调用方法
        """
        status = OperateProductUtil.ipmc_tool_rollback_product(
            deploy_id, product_name, task_detail, work_path, target_version, **kwargs)
        # 删除NCE回滚检查文件
        rollback_check_json = os.path.join(work_path, "rollback_check.json")
        if os.path.isfile(rollback_check_json):
            os.remove(rollback_check_json)
        if status is False:
            self.rollback_product_status = False
            return self.rollback_product_status
        self.rollback_product_status = True
        return self.rollback_product_status


def main(argv):
    params = OperateProductUtil.format_params(argv)
    script_id = params.get("script_id")
    e_task_path = os.path.join("/opt/upgrade/easysuite_upgrade/taskmgr", script_id)
    if not OperateProductUtil.is_path_valid(script_id):
        logger.error("script_id %s is invalid" % script_id)
        return False
    params.update({"task_id_path": e_task_path})
    operate_function = Operateproduct(params)
    if params.get('operation') == "upgrade":
        product_pkgs = params.get("product_pkgs")
        offline_pkgs = params.get("offline_pkgs", "")
        upgrade_start_policy = params.get("upgrade_start_policy", "")
        result = operate_function.fresh_omp_json("fresh")
        if not result:
            return False
        operate_function.upgrade_product(params.get('des_version'), params.get('task_id_path'),
                                         product_pkgs, offline_pkgs, upgrade_start_policy,
                                         params.get("parallel_installation", ""))
        result = operate_function.fresh_omp_json("recover")
        if not result:
            return False
    else:
        result = operate_function.fresh_omp_json("fresh")
        if not result:
            return False
        
        operate_function.rollback_product(params.get('task_id_path'), params.get('src_version'),
                                          params)
        result = operate_function.fresh_omp_json("recover")
        if not result:
            return False


if __name__ == '__main__':
    main(sys.argv)
