#!/bin/bash
##################################################
# ȡű·ͽű
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# ʼ־·־ļ
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

##################################################
# ̶
##################################################
# ΨһID
TASKID="${1}"
#  set-ssh\sync-dr
ACTION="${2}"
# Ƿ
SKIPNOHUP="${5}"

#######################################
# ȡЧ
#######################################
function get_valid_params()
{
    local params_one="${1}"
    local params_two="${2}"
    # "None" \ "--" Чֵ
    if [ "${params_one}" == "None" -o "${params_one}" == "--" ]
    then
        echo ${params_two}
        return 0
    fi
    echo ${params_one}
    return 0
}

##################################################
# ȡ
##################################################
function init_params()
{
    # ⲿ
    if [ $# -ne 5 -a $# -ne 4 ]
    then
        return 1
    fi

    # ԶNMS01_IP
    REMOTE_NMS_IP="${3}"

    # ԶOMP01 IP
    REMOTE_OMP_IP="${4}"

    REMOTE_NODE_IP="$(get_valid_params "${REMOTE_NMS_IP}" "${REMOTE_OMP_IP}")"
}

##################################################
# ȡ
##################################################
function record_es_log()
{
    LOG_PRINT "${1}" "${2}" >>"${TASK_LOG_FILE}"
}

#######################################
# ssh֤IP,IPV6
#######################################
function set_ssh()
{
    local remote_ip="${1}"
    record_es_log "INFO" "Start to set ssh extend ip"
    ssh_script="/opt/oss/manager/agent/bin/sshd_ipsadm.sh"
    ssh_params="-cmd set -extips "${remote_ip}""
    record_es_log "INFO" "Cmd:${ssh_script} ${ssh_params}"
    bash "${ssh_script}" "${ssh_params}" >>"${TASK_LOG_FILE}"
    result=$?
    if [ ${result} -ne 0 ]
    then
        record_es_log "INFO" "Failed to set ssh extend ip"
        return 1
    fi
    record_es_log "INFO" "Finished to set ssh extend ip"
    return 0
}

#######################################
# ִ֤ͬű
#######################################
function exe_sync_script()
{
    local remote_ip="${1}"
    # expectȡ
    local remote_node_pwd="${2}"
    # \,{,},[,],`,"ʱʹǰʧЧת
    remote_node_pwd=$(echo ${remote_node_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    record_es_log "INFO" "Start to sync dr authertication"
    # ϢԷϢй¶
    expect <<END >>"${TASK_LOG_FILE}" 2>&1
        set timeout 7200
        spawn bash /opt/oss/manager/apps/DRMgrService/bin/syncDRVerification.sh -type all -remoteip "${remote_ip}"
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "*assword:" {exec sleep 1;send -- "${remote_node_pwd}\r"}
        }
        expect eof
        catch wait result;
        exit [lindex \$result 3]
END
    result=$?
    sed -i "s/${remote_node_pwd}//g" "${TASK_LOG_FILE}"
    if [ ${result} -ne 0 ]
    then
        record_es_log "INFO" "Failed to sync dr authertication"
        return 1
    fi
    record_es_log "INFO" "Finished to sync dr authertication"
    return 0
}

#######################################
# ǽ
#######################################
function main()
{
    # ع
    . ${SCRIPT_PATH}/common.sh
    LOG "INFO" "Start to init ${LOG_FILE}."
    init_params "$@" || return 1
    # ʼ
    init_taskmgr "${TASKID}"
    TASK_LOG_FILE="${TASK_MGR_PATH}/${TASKID}/task.log"
    fresh_es_progress "${TASKID}" "1"
    if [ "${ACTION}" == "--set-ssh" ]
    then
        for one_node_ip in ${REMOTE_NODE_IP//,/ }
        do
            set_ssh "${one_node_ip}"
        done
    else
        # ־ļжϷ
        flag_file="${SCRIPT_PATH}/${SELF_FILE//.sh/}${RANDOM}"
        rm -f "${flag_file}" &>/dev/null

        # 
        (exe_sync_script "${REMOTE_NODE_IP}" "${NODE_PWD}";echo "$?" >"${flag_file}" )&

        # ˢ½,ʧܷ
        fresh_task_progress "${TASKID}" "30" "${flag_file}"
    fi
    if [ $? -ne 0 ]
    then
        do_exit "${TASKID}"
        return 1
    fi
    fresh_es_status "${TASKID}" "success"
    fresh_es_progress "${TASKID}" "100"
}

#######################################
# 
#######################################
function interact_main()
{
    if [ "${ACTION}" == "--sync-dr" -a -z "${SKIPNOHUP}" ]
    then
        echo -n "es_input: node_standby_nmsserver_ossadm_pwd"
        read -sr NODE_NMS_PWD
        echo -n "es_input: node_standby_omp01_ossadm_pwd"
        read -sr NODE_OMP_PWD
        NODE_PWD="$(get_valid_params "${NODE_NMS_PWD}" "${NODE_OMP_PWD}")"
        # Ϲ
        main "$@" "yes" &>/dev/null &
    else
        main "$@"
    fi
}

interact_main "$@"
exit 0
