#!/bin/bash

##########################################
# kill root权限的easysuite进程
##########################################
function main() {
    # 获取包含19090、manage.py等关键信息，并且是root权限的进程号
    es_pids=`ps -ef | grep 19090 | grep manage.py | grep -v grep | grep -E "^root" | awk '{print $2}'`
    # 获取监听19090端口的进程号
    listen_19090_pids=`netstat -anp 2>/dev/null | grep "tcp.*19090.*LISTEN" | awk '{print $NF}' | awk -F/ '{print $1}'`
    if [ -z "${es_pids}" -a -z "${listen_19090_pids}" ]
    then
        return 0
    fi
    # 取上述两个进程号的交集，表示root权限的easysuite任务，将其kill
    for es_pid in "${es_pids}"
    do
      for listen_19090_pid in "${listen_19090_pids}"
      do
        if [ "${listen_19090_pid}" == "${es_pid}" ]
        then
          echo "kill root EasySuite process: ${es_pid}"
          kill -9 "${es_pid}"
        fi
      done
    done
}

main
exit $?