#!/bin/bash
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

# 检查当前执行用户
function checkID()
{
    idInfo="$(id)"
    for f_idInfo in ${idInfo[@]}
    do
        if [[ "${f_idInfo}" =~ "uid" ]]
        then
            if [[ "${f_idInfo}" =~ "ossadm" ]]
            then
                return 0
            else
                echo "The script must run with ossadm user."
                return 1
            fi
        else
            continue
        fi
    done
    echo "The script must run with ossadm user."
    return 1
}

###################################
#主体函数
###################################
function main()
{
    #检查脚本执行用户是否合法
    checkID || return 1
    
    PRODUCT_NAME="${1}"
    if [ -z "${PRODUCT_NAME}" ]
    then
        return 1
    fi
    . /opt/oss/manager/bin/engr_profile.sh
    if [ -f "${SCRIPT_PATH}"/pyscripts/query_feature.py ]
    then
        python "${SCRIPT_PATH}"/pyscripts/query_feature.py "${PRODUCT_NAME}"
        return $?
    elif [ -f "${SCRIPT_PATH}"/pyscripts/query_feature.pyc ]
    then
        python "${SCRIPT_PATH}"/pyscripts/query_feature.pyc "${PRODUCT_NAME}"
        return $?
    else
        return 1
    fi
}

main "$@"
exit $?
