#!/bin/bash
###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
# Description: 判断是否是不兼容OS版本，若当前环境为Euler系统R7/R8则返回0，代表必须要升级，否则返回1
###############################################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

# 检查当前环境操作系统类型
function get_os_compatibility()
{
    if [ -e /etc/euleros-release ] 
    then
        LOG "INFO" "The current environment linux release version is euler."
        uname -a | grep -E "v2r7|v2r8" &>>"${LOG_FILE}"
        return $?
    fi
    return 1
}

###################################
#主体函数
###################################
function main()
{
    #加载公共方法
    source ${SCRIPT_PATH}/easysuite_upgrade_scripts/common.sh

    #判断是否为不兼容OS
    get_os_compatibility
    return $?
}

main "$@"
exit $?
