#!/bin/bash

#脚本所在路径
SCRIPT_PATH=$(cd $(dirname $0);pwd)

# 创建目录
function create()
{
    # 目录不存在
    mkdir -p /opt/upgrade

    # 目录不存在清理
    [ -d /opt/upgrade -a ! -L /opt/upgrade ] && chown ossadm:ossgroup /opt/upgrade && chmod 750 /opt/upgrade && id sopuser 2>/dev/null && setfacl -m u:sopuser:r-x /opt/upgrade
}

# 主入口
function main()
{
    # 加载公共方法
    source ${SCRIPT_PATH}/common.sh

    # 检查脚本执行用户
    check_user || return $?

    # 创建升级目录
    create "$@"
}

main "$@"
exit $?