#!/usr/bin/env bash

###############################################################################################
function fn_get_log_file_path()
{
    echo "${c_root_path}/cmd.repair.log"
    return 0
}

###################################################
#
# 执行远端命令
#
###################################################
function fn_run_command_remote()
{
    fn_info_screen "Start executing remote cmds."
    fn_sys_log_info "Start executing remote cmds."
    host_ip="$1"
    user="$2"
    passwd="$3"
    command="$4"
    timeout="$5"
    is_log="$6"
    exec_cmd_remote "${host_ip}" "${user}" "${timeout}" "${command}" "${is_log}" << EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && return ${result}
    fn_info_screen "Success to execute the remote command." && return 0
    fn_sys_log_info "Success to execute the remote command." && return 0
}

function fn_cp_file_remote()
{
    fn_info_screen "Copy the file/dict to the remote node."
    fn_sys_log_info "Copy the file/dict to the remote node."
    host_ip="$1"
    timeout="$2"
    c_src_path="$3"
    c_path_des="$4"
    passwd="$5"
    cp_file_to_remote "${host_ip}" "root" "${timeout}" "${c_src_path}" "${c_path_des}" "0" <<EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && fn_sys_log_error "Failed to copy files to the remote end." && fn_error_screen "[ERROR]Failed to copy files to the remote end." && return 1
    fn_info_screen "Success to copy files to the remote end."
    fn_sys_log_info "Success to copy files to the remote end." && return 0
}

###############################################################################################
function fn_init()
{
    readonly c_root_path=$(dirname $(readlink -f $0 ))
    source ${c_root_path}/shscript/utils/load_all_util.sh
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"
    readonly c_log_file="$(fn_get_log_file_path)"
    rm -f "${c_log_file}"
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"

    return 0
}

###############################################################################################
# 1 执行用户是否是root
###############################################################################################
function fn_precheck()
{
    fn_info_screen "Precheck before restore."
    fn_sys_log_info "Precheck before restore."
    fn_sys_assert_current_user_matched "root" || return 1
    return 0
}

###############################################################################################

###############################################################################################
function fn_init_node_passwd()
{
    echo -n "Enter the password of the root user: "
    IFS=$'\n'
    read -sr remote_password
    echo -e "\n"
    echo "Start to repair ... "
}

###############################################################################################
function fn_do() {
  fn_sys_log_info "Start to rm repair flag."
  rs=1
  local check_service="NdpLdapService|NdpNameNodeService|NdpRedisService|NdpJournalNodeService|NdpKerberosService"
  for i in $(seq 1 50); do
    fn_sys_log_info "Waiting for Ndp  RUNNING"
    fn_run_command_remote ${restore_ip} "root" ${remote_password}  "su - ossadm -c '/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp | grep -v RUNNING' | grep -E '${check_service}'" "3600" "0"
    [[ $? -eq 1 ]] && rs=0 && break
    sleep 10
  done
  fn_run_command_remote ${restore_ip} "root" ${remote_password} "rm -f /tmp/ndp_repair_node.flag;" "5" "0"
  [[ "$?" -ne "0" ]] && fn_sys_log_error "rm repair failed ..." && return 1
  fn_sys_log_info "rm repair success ...."
  return ${rs}

}
###############################################################################################
function fn_main()
{

    readonly c_start_time="$(date +%s)"
    restore_ip=$1
    product_name=$2
    fn_init_node_passwd
    fn_init || return 1
    fn_sys_log_enter
    fn_precheck || return 1
    fn_do || return 1
#
    local l_result="$?"
    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_info_screen "Result [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    fn_sys_log_leave "Result [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    return "$l_result"
}

###############################################################################################

fn_main "$@"
result="$?"
exit "${result}"
