#!/usr/bin/env bash

###############################################################################################
function fn_get_log_file_path()
{
    echo "${c_root_path}/cmd.backup_kafka_metadata.log"
    return 0
}
function fn_get_all_log_file_path()
{
    echo "${c_root_path}/cmd.backup_kafka_metadata_all.log"
    return 0
}

###############################################################################################
function fn_init()
{
    readonly c_script_path=$(dirname $(readlink -f $0 ))
    # Loading Modules
    readonly c_root_path=${c_script_path}/../../
    source ${c_root_path}/shscript/utils/load_all_util.sh
    source ${c_root_path}/shscript/profile/upgrade_profile.sh

    export PYTHONPATH=${c_root_path}/pyscript:${PYTHONPATH}
    # Initialization Log
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"

    readonly c_log_file="$(fn_get_log_file_path)"
    readonly fi_install_path="/opt/huawei/Bigdata"
    readonly fi_oms_cofig="${fi_install_path}/om-server/OMS/workspace/conf/oms-config.ini"
    readonly ws_ip=$(cat ${fi_oms_cofig} | grep "ws_float_ip=" | awk -F '=' '{print $2}')

    ls ${c_root_path}/python-*.zip >/dev/null 2>&1;
    [[ $? -eq 0 ]] && python_rtsp_path=$(ls ${c_root_path}/python-*.zip)

    if [[ -f ${python_rtsp_path} ]]; then
        rm -rf "${c_root_path}/python" >/dev/null 2>&1;
        unzip ${python_rtsp_path} -d "${c_root_path}/python" >/dev/null 2>&1;
        PYTHONHOME="${c_root_path}/python"
    fi


    # save history log file
    readonly all_log_file="$(fn_get_all_log_file_path)"
    fn_sys_create_log_file "$all_log_file"
    [ -f "${c_log_file}" ]  && cat "${c_log_file}" >> ${all_log_file}

    [[ -f ${c_log_file} ]] && rm -f ${c_log_file}
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"

    return 0
}

###############################################################################################
function fn_get_pwd()
{
    fn_sys_log_info "start to get FI password."
    readonly fi_login_password=$(cat ${tar_tmp_pwd_file})
    rm -f ${tar_tmp_pwd_file}
    return 0
}

###############################################################################################
function fn_precheck()
{
    fn_sys_log_info "Precheck before pre-installation check."
    fn_sys_assert_current_user_matched "root" || return 1
    [[ "$(fn_sys_is_valid_ip ${ws_ip})" == "false" ]] && fn_sys_log_error "The floating IP address of the FusionInsight in the configuration file is not a valid IP address." && return 1
    fn_sys_assert_is_directory "fi_install_path" || fn_sys_log_error "The node is not the node where the FusionInsight is installed." || return 1
    fn_sys_assert_not_null "fi_login_password" || return 1
    [[ ! -d ${PYTHONHOME} ]] && fn_sys_log_error "Could not find python home." && return 1

    return 0
}

###############################################################################################
function fn_do()
{
    fn_get_pwd

    fn_precheck || return 1

    # 清理之前生成的数据并重新调用接口生成
    rm -rf ${fi_install_path}/LocalBackup/${g_upgrade_cluster_id}/backup_upgrade_*
    ${PYTHONHOME}/bin/python "${c_root_path}/pyscript/actions/backup_kafka_metadata.pyc" "${ws_ip}" "${c_log_file}" >> ${c_log_file} 2>&1 <<EOF
${fi_login_password}
EOF
    [[ $? != 0 ]] && fn_sys_log_error "Failed to backup Kafka data." && return 1

    # 循环等待5min 看是否有备份完毕。
    fn_sys_log_info "Start to check backup Kafka data file..."
    times=1
    while (( $times < 300 ))
    do
        ls -t ${fi_install_path}/LocalBackup/${g_upgrade_cluster_id}/backup_upgrade_*/Kafka*/*Kafka-Metadata*.tar.gz > /dev/null 2>&1
        [[ $? -eq 0 ]] && fn_sys_log_info "Success to get backup Kafka data file." && break
        (( times++ ))
        sleep 1
    done
    adjust_kafka_meta_back_file=$(ls -t ${fi_install_path}/LocalBackup/${g_upgrade_cluster_id}/backup_upgrade_*/Kafka*/*Kafka-Metadata*.tar.gz | head -1)
    [[ -f ${adjust_kafka_meta_back_file} ]] && fn_sys_log_info "Success to get backup Kafka data file." && return 0
    fn_sys_log_error "Failed to backup Kafka data."
    return 1
}

###############################################################################################
function fn_main()
{
    readonly c_start_time="$(date +%s)"
    fn_init
    fn_sys_log_info "Start to backup kafka metadata."
    fn_do
    local l_result="$?"

    fn_sys_log_info "Start to create a process exit flag."
    touch ${g_process_kafka_backup_flag}
    fn_sys_log_info "End to create a process exit flag."

    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_info "Leave post_install with status [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    [[ ${l_result} -ne 0 ]] && fn_sys_log_error "Failed to run backup kafka."
    return "$l_result"
}

###############################################################################################

fn_main "$@"
result="$?"
exit "$result"
