#!/bin/bash

function check_dirs_and_files()
{
	host_ip=$1
	# 定义需要检查的目录和文件
	local dirs=(
		/srv/BigData/namenode/current/
		/srv/BigData/journalnode
		/srv/BigData/ldapData
		/srv/BigData/namenode
		/srv/BigData/redis
		/srv/BigData/redis_meta
		/srv/BigData/tmp
		/srv/BigData/zookeeper
		/opt/huawei/Bigdata/
	)
	local files=(
		/opt/oss/manager/etc/sysconf/nodelists.json
		/opt/huawei/Bigdata/om-server/OMS/workspace/conf/oms-config.ini
		/opt/huawei/Bigdata/om-server/om/security/cert/root/ca.crt
		/opt/huawei/Bigdata/om-server/OMS/workspace/conf/oms-config.ini
		/opt/oss/manager/agent/bin/engr_profile.sh
		/opt/huawei/Bigdata/upgrade_local_launch.sh
		/opt/huawei/Bigdata/components/FusionInsight_HD_*/Redis/client/bin/redis-cli
		/opt/huawei/Bigdata/FusionInsight_Current/*quorumpeer/etc/ENV_VARS
		/opt/huawei/Bigdata/FusionInsight_Current/*Broker/etc/server.properties
		/opt/huawei/Bigdata/FusionInsight_Current/*NameNode/etc/hdfs-site.xml
		/opt/huawei/Bigdata/FusionInsight_Current/*ResourceManager/etc/yarn-site.xml
	)
	# 检查目录是否存在
	fn_sys_log_info "${host_ip}: Start to checking Directory"
		for dir in "${dirs[@]}";do
			if [[ ! -e "$dir" ]];then
				fn_sys_log_error "${host_ip}: Directory '$dir' doesn't exist.Checking the service status and supplement this Directory."
			else
				fn_sys_log_info "${host_ip}: Directory '$dir' exist."
			fi
		done
	# 检查文件是否存在
	fn_sys_log_info "${host_ip}: Start to checking Files"
		for file in "${files[@]}";do
			if [[ -f "$file" ]];then
				fn_sys_log_info "${host_ip}: File '$file' exists."
			else
				fn_sys_log_error "${host_ip}: File '$file' doesn't exist.Checking the service status and supplement this File."
			fi
		done
	fn_sys_log_info "${host_ip}: Finishing checking Files and Directorys."
}