#!/bin/bash
#
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
#

###################################################################################
# 执行节点： FI客户端节点
# 执行依赖： 依赖FI客户端
# 参数：
#     1) FI客户端路径
#     2) FI客户端连接keytab路径
# 执行返回值：
#     0 ：执行检查成功
#     非0 ：执行检查失败
###################################################################################

function fn_init() {
  local l_client_dir=$1
  local l_keytab=$2
  local l_user

  source "${l_client_dir}/bigdata_env"
  l_user=$(klist -kt "${l_keytab}" | grep "hbase/zkclient" |head -1 | awk '{print $4}')
  if [[ $? -ne 0 ]];then
    return 1
  fi
  kinit -kt "${l_keytab}" "${l_user}" >/dev/null
  return $?
}

function fn_log_screen() {
    local log_level="$1"
    local l_message="$2"
    echo "[$(date -d today +"%Y-%m-%d %H:%M:%S")][${log_level}] ${l_message}"
}


function fn_log_error() {
    local l_message=$1
    fn_log_screen "ERROR" "${l_message}"
}

function fn_log_info() {
    local l_message=$1
    fn_log_screen "INFO" "${l_message}"
}

function fn_check_hdfs_badblock() {
  local res_info
  res_info="$(timeout 200 hdfs fsck /)"
  if [[ $? -ne 0 ]]; then
      fn_log_error "hdfs fsck failed"
      return 1
  fi
  local corrupt_blocks
  corrupt_blocks=$(echo "${res_info}" | grep "Corrupt blocks:" | awk '{print $3}')
  if [ "${corrupt_blocks}" == "0" ]; then
      return 0
  fi
  return 1
}

function fn_check_hbase_by_hbck() {
  report=$(timeout 200 hbase hbck >/dev/null)
  return $?
}

function main() {
  local l_client_dir=$1
  local l_keytab=$2

  if [[ $# -ne 2 ]];then
    fn_log_screen "WARN" "param error, need flush your script"
    return 0
  fi

  if ! fn_init "${l_client_dir}" "${l_keytab}"; then
    fn_log_error "init keytab failed"
    return 1
  fi

  if ! fn_check_hdfs_badblock; then
    fn_log_error "hdfs has bad block"
    return 1
  fi

  if ! fn_check_hbase_by_hbck; then
    fn_log_error "hbase has corrupt region"
    return 1
  fi

  fn_log_info "hbase check finished"
  return 0
}

main "$@"
exit $?
