#!/bin/bash

check_dns()
{
    host_ip=$1
    local dns_file="/etc/resolv.conf"

    fn_sys_log_info "${host_ip}: Start checking DNS configuration in file ${dns_file}."

    if [[ ! -f ${dns_file} ]]; then
        fn_sys_log_info "${host_ip}: ${dns_file} doesn't exist."
        return
    fi

    cat ${dns_file} | grep -q ^[[:blank:]]*nameserver

    if [[ $? -eq 0 ]]; then
        fn_sys_log_warn "${host_ip}: If nameserver is configured improperly, the network speed is slowed down, which affects the subsequent installation or operations. Check whether the item is correctly configured."
    else
        fn_sys_log_info "${host_ip}: nameserver is not configured in the file ${dns_file}."
    fi
    fn_sys_log_info "${host_ip}: Success checking DNS configuration in file ${dns_file}."
}

