#!/bin/bash

################################################
# Usage: check_permission.sh
# :  ļȨ
#
################################################

###################################################
#
# ļȨ
#
###################################################
function check_permission()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking file permission."
    
    #ļȨ飬ʽΪĿ¼:ļͼȨ::顱ԪԿոָ
    local key_file_array=(/tmp:drwxrwxrwt:root:root)

    for element in "${key_file_array[@]}";
    do
        local FILE=$(echo ${element} | awk  -F ':' '{print $1}')
        local PERMISSION=$(echo ${element} | awk  -F ':' '{print $2}')
        local OWNER=$(echo ${element} | awk  -F ':' '{print $3}')
        local GROUP=$(echo ${element} | awk  -F ':' '{print $4}')
        
        if [ -z "${FILE}" -o -z "${PERMISSION}" -o -z "${OWNER}" -o -z "${GROUP}" ]; then
            fn_sys_log_warn "${host_ip}: Wrong format of item ${element}."
            continue
        fi

        local permission=$(stat -c %A ${FILE})
        if [[ "/tmp" == ${FILE} ]]; then
            [[ X${permission} != X${PERMISSION} ]] && fn_sys_log_error "${host_ip}: The permission for ${FILE} is ${permission} instead of the expected ${PERMISSION}."
        else
            [[ X${permission} != X${PERMISSION} ]] && fn_sys_log_warn "${host_ip}: The permission for ${FILE} is ${permission} instead of the expected ${PERMISSION}."
        fi

        local owner=$(stat -c %U ${FILE})
        [[ X${owner} != X${OWNER} ]] && fn_sys_log_warn "${host_ip}: The owner for ${FILE} is ${owner} instead of the expected ${OWNER}."
        
        local group=$(stat -c %G ${FILE})
        [[ X${group} != X${GROUP} ]] && fn_sys_log_warn "${host_ip}: The group for ${FILE} is ${group} instead of the expected ${GROUP}."
    done
    fn_sys_log_info "${host_ip}: Success checking file permission."
}
