#!/usr/bin/env bash

logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1); start to after_work"
CURRENT_PATH=$(cd $(dirname $0); pwd)
ENT_TOOLS_DIR="/opt/entTools"

function check_user()
{
	current_user=$(whoami)
	if [[ "$current_user" != "root" ]]
	then
		echo "Please switch root user."
		exit 1
	fi
}
check_user

function check_execute_node_id()
{
    current_node_id=$(cat /opt/oss/manager/var/agent/mcagentid.conf | awk -F'=' '{print $2}')
    faulty_node_id=$(cat ${ENT_TOOLS_DIR}/conf/config.properties | grep "faulty_node_id=" | awk -F'=' '{print $2}')
    if [[ "$current_node_id" != "$faulty_node_id" ]]
    then
        echo "Please execute this script on faulty node."
        exit 1
    fi
}
check_execute_node_id

function deal_scripts()
{
    faulty_node_id=$(cat ${ENT_TOOLS_DIR}/conf/config.properties | grep "faulty_node_id=" | awk -F'=' '{print $2}')
    if [[ ! -f /etc/uuid/uuid.txt ]]
    then
        mkdir /etc/uuid
        echo ${faulty_node_id} > /etc/uuid/uuid.txt
        chown -R ossadm:ossgroup /etc/uuid
    fi

    if [[ ! -f /usr/local/insight/bin/log_collect.sh ]]
    then
        echo "lost log_collect.sh script,please confirm"
        return 1
    fi
    crontab -l | grep -v log_collect.sh > /tmp/tmp_crontab_conf
    echo '*/5 * * * * bash /usr/local/insight/bin/log_collect.sh >/dev/null 2>&1' >> /tmp/tmp_crontab_conf
    crontab /tmp/tmp_crontab_conf
    rm -f /tmp/tmp_crontab_conf

    execute_node_ip=$(cat ${ENT_TOOLS_DIR}/conf/config.properties | grep "execute_node_ip=" | awk -F'=' '{print $2}')
    ssh -o StrictHostKeyChecking=no ${execute_node_ip} "ls /opt/oss/*/apps/NdpToolService/" >/dev/null 2>&1
    if [[ $? -ne 0 ]]
    then
        selectedNetType="one_button_repair_mda"
    else
        selectedNetType="one_button_repair"
    fi

    faulty_node_type=$(cat ${ENT_TOOLS_DIR}/conf/config.properties | grep "faulty_node_type=" | awk -F'=' '{print $2}')
    if [[ ${faulty_node_type} =~ "Collector" || ${faulty_node_type} =~ "xFlow" || ${selectedNetType} == "one_button_repair_mda" ]]
    then
        echo "Success to deal scripts,continue."
        return 0
    fi

    echo "Success to deal scripts,continue."
    return 0
}

function deal_pwd_dict()
{
    if [[ ! -f /tmp/faulty_dict.tmp ]]
    then
        echo "no faulty_dict.tmp,please confirm"
        return 1
    fi
    create-cracklib-dict /tmp/faulty_dict.tmp >/dev/null 2>&1
    if [[ $? -ne 0 ]]
    then
        echo "Failed to import pwd dict,please confirm."
        return 1
    fi
    rm -rf /tmp/faulty_dict.tmp
    ssh -o StrictHostKeyChecking=no ${execute_node_ip} "rm -rf /tmp/faulty_dict.tmp"
    echo "Success to import pwd dict,continue."
    return 0
}

function config_account_isolation()
{
    if [[ "${faulty_node_id}" == "0" ]]
    then
        return 0
    fi

    ssh -o StrictHostKeyChecking=no ${execute_node_ip} "su - ossadm -c '. /opt/oss/manager/bin/engr_profile.sh; sshd_ipsadm.sh -cmd set -force'"
    if [[ $? -eq 0 ]]
    then
        echo "Success to config account isolation,continue."
        return 0
    else
        echo "Failed to config account isolation,please confirm."
        return 1
    fi
}

function do_after_work()
{
    ${CURRENT_PATH}/../script/python/bin/python ${CURRENT_PATH}/../script/launch.pyc processor -i -exec post.one_button_repair.faulty_post_repair -selectedNetType ${selectedNetType}
    if [[ $? -eq 0 ]]
    then
        echo "Success to do post repair,continue."
    else
        echo "Failed to do post repair,exit."
        return 1
    fi
    ${CURRENT_PATH}/../script/python/bin/python ${CURRENT_PATH}/../script/launch.pyc processor -i -exec post.install.clear_envs -selectedNetType ${selectedNetType}
    if [[ $? -eq 0 ]]
	then
		sleep 10
		service sshd restart >/dev/null 2>&1
		echo "Success to do after work,ended."
		return 0
	fi
	echo "Failed to do after work,exit."
    return 1
}

main()
{
    deal_scripts || return 1
    deal_pwd_dict || return 1
    config_account_isolation || return 1
    do_after_work || return 1
}

main
ret=$?
logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1);execute after_work ended"
exit ${ret}