#!/bin/bash

versionconf=$2/plandata.json

versionflag=`grep "src_version" $versionconf | grep V100R019`
if [ -z "$versionflag" ] 
then
    exit 0
fi

manageripconf=${OSS_ROOT}/var/agent/managerip.conf

managerip=`grep -w managerip $manageripconf | awk -F "=" '{print$2}'`

masterip=""
slaveip=""

if [[ $managerip =~ "," ]]
then
    masterip=`echo $managerip | awk -F "," '{print$1}'`
	slaveip=`echo $managerip | awk -F "," '{print$2}'`
else
    masterip=$managerip
fi


_APP_SHARE_DIR=/opt/oss/share/manager/DBAgent
containerlistcmd="rm -rf ${_APP_SHARE_DIR}/containerlist.json"


if [ -n "$masterip" ] 
then
    sh ${OSS_ROOT}/tools/common/sshmgr/sshmgr.sh -exectype cmd -ip $masterip -cmd "$containerlistcmd" -timeout 1000
	masterresult=$?
    if [[ "$masterresult" == "0" ]]
    then
        echo "delete master DBAgent containerlist Successful"
    else
        echo "delete master DBAgent containerlist Failed $masterresult"
        exit 1
    fi
fi


if [ -n "$slaveip" ] 
then 
    sh ${OSS_ROOT}/tools/common/sshmgr/sshmgr.sh -exectype cmd -ip $slaveip -cmd "$containerlistcmd" -timeout 1000
	slaveresult=$?
    if [[ "$slaveresult" == "0" ]]
    then
        echo "delete slave DBAgent containerlist Successful"
    else
        echo "delete slave DBAgent containerlist Failed $slaveresult"
        exit 1
    fi
fi

exit 0