#!/bin/bash

SCRIPT_PATH=$(cd $(dirname $0);pwd)
INSTALL_ROOT="/opt/oss"

function check_input()
{
    if [ "${1}" == "-input" -a -n "${2}" ]
    then
        INPUT_FILE_PATH=${2}
    else
        echo "ERROR The input param is invalid."
        exit 1
    fi
    if [ "${3}" == "-output" -a -n "${4}" ]
    then
        OUTPUT_FILE_PATH=${4}
    else
        echo "ERROR The output param is invalid."
        exit 1
    fi
}

#check current user
function checkUser()
{
    cur_user=`id -un`
    [ ${cur_user} == "ossadm" ] && return 0
    echo "The script must run with ossadm user."
    exit 1
}

function checkAndSetCfg()
{
    cp ${SCRIPT_PATH}/param_plan_ClientPkgMgrService.json ${OUTPUT_FILE_PATH}
}
check_input "$@"
checkUser
checkAndSetCfg
if [ $? -ne 0 ]
then
    echo "plandata_custom_ClientPkgMgrService.sh script run failed"
    exit 1
else
    echo "plandata_custom_ClientPkgMgrService.sh script run successfully"
    exit 0
fi
