#!/bin/bash
##########################################
#创建cfg文件 param=传入路径
##########################################
function mk_file()
{
    if [ -f "${2}"/plandata.json ]
	then
        productname=$(grep -Po 'productname[" :]+\K[^"]+'  "${2}"/plandata.json)
        if [ $? -ne 0 ]
        then
            echo "No productname is found in the plandata.json file."
            exit 1
        fi
        source_version=$(grep -Po 'src_version[" :]+\K[^"]+'  "${2}"/plandata.json)
        if [ $? -ne 0 ]
        then
            echo "No source_version is found in the plandata.json file."
            exit 1
        fi
        target_version=$(grep -Po 'des_version[" :]+\K[^"]+'  "${2}"/plandata.json)
        if [ $? -ne 0 ]
        then
            echo "No target_version is found in the plandata.json file."
            exit 1
        fi
        if [ ! -d /opt/oss/patch/ ]
        then
            mkdir -p /opt/oss/patch/
        fi
        file_name=/opt/oss/patch/"${productname}_${source_version}_${target_version}_$(date '+%s')".cfg
        touch "${file_name}"
        chmod 640 "${file_name}"
	else
	    echo "${2}/plandata.json does not exist."
	fi
}

mk_file "$@"
exit $?
