#!/bin/bash

# NCE DBAgent BIN目录路径
DBAGENT_BIN_FOLDER="/opt/oss/manager/apps/DBAgent/bin"
# 数据库名称
MY_DATABASE=("trustattestationservicedb", "zerotrustassessengineservicedb", "HISI_SOAR_RDB")
# 数据库实例
REAL_db_instance_id="hisecadvancedsecdbsvr"

# 当前脚本名称
SCRIPT_NAME=`basename $0`
# 升级日志目录
LOG_FILE="/opt/oss/log/manager/easysuite_upgrade/${SCRIPT_NAME}.log"

# 日志记录
function log(){
  local msg=$1
  echo "[$(date +'%Y-%m-%d %H:%M:%S')] $msg" |tee -a $LOG_FILE
}

# 校验入参
function check_input(){
  if [ "${1}" == "-input" -a -n "${2}" ]
  then
    INPUT_PATH=${2}
  else
    log "ERROR The input param is invalid."
    exit 0
  fi
}

# 检查版本 只有22.0升级到23.0后的回退，才需要设置新实例不可见
function check_version(){
  src_version=`cat ${INPUT_PATH}/plandata.json | grep src_version | tr '"' ' ' | awk '{print $3 }'`
  is_R22C00=`echo ${src_version} | grep R022C00`
  if [ -z "${is_R22C00}" ]
  then
    log "src_version ${src_version} is not R22C00"
    exit 0
  fi
}

# 检查环境版本
function check_env_version(){
  software_version=`cat /opt/oss/manager/var/share/software_define.yaml | grep softwareVersion`
  is_R023C00=`echo ${software_version} | grep R023C00`
  if [ -z "${is_R023C00}" ]
  then
    echo "current_env_version ${software_version} is not R023C00"
    exit 0
  fi
}


# 检查DBAgent BIN目录路径
function check_agent_dir(){
  if [ ! -d "$DBAGENT_BIN_FOLDER" ]
  then
    log "DBAgent bin directory is not exists"
    exit 1
  fi
}

# 获取并填充数据库实例名
function fill_real_database_map(){
  cd "$DBAGENT_BIN_FOLDER"
  log "start to query hisecadvancedsecdbsvr instance id...."
  db_instance_id=`./dbsvc_adm -cmd query-db-instance |grep "hisecadvancedsecdbsvr*" | head -n 1 | awk -F " " '{print $1}'`
  
    if [ "$?" -eq "0" ]
    then
	  if [ -z "${db_instance_id}" ]
	  then
	    log "hisecadvancedsecdbsvr instance id is not exists"
		exit 0
	  else
	    log "query hisecadvancedsecdbsvr instance id ${db_instance_id} success...."
	    REAL_DB_INSTANCE_ID=${db_instance_id}
	  fi
    else
	  log "query hisecadvancedsecdbsvr instance id failed...."
	  exit 1
    fi
}

# 遍历编排数据库不可见
function set_database_unvisible(){
  for db_name in ${MY_DATABASE[@]};do
    log "start to set ${REAL_DB_INSTANCE_ID} ${db_name} unvisible...."
    ./dbsvc_adm -cmd set-database-status -instid ${REAL_DB_INSTANCE_ID} -dbnames ${db_name} -visible false

    if [ "$?" -eq "0" ]
    then
	  log "set ${REAL_DB_INSTANCE_ID} ${db_name} unvisible success...."
    else
	  log "set ${REAL_DB_INSTANCE_ID} ${db_name} unvisible failed...."
	  exit 1
    fi
  done
}

check_env_version
check_input "$@"
check_version
check_agent_dir
fill_real_database_map
set_database_unvisible

exit 0
 