#!/bin/bash
##########################################
#删除平台预制证书
##########################################
SCRIPT_NAME=`basename $0`
LOG_FILE="/opt/oss/log/manager/easysuite_upgrade/${SCRIPT_NAME}.log"

# 日志记录
function log()
{
    local msg=$1
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] $msg"  >> $LOG_FILE
}

function check_param()
{
    local check_tmp=$1
    [ -z "${check_tmp}" ] && return 1
    echo "${check_tmp}" | fgrep -q "../"
    if [ $? -eq 0 ]
    then
        log "ERROR: The input param \"${check_tmp}\" is invalid."
        return 1
    fi
    if [ ! -d "${check_tmp}" ]
    then
        log "ERROR: The input param \"${check_tmp}\" is invalid."
        return 1
    fi
}

# 获取输入参数
function init_params()
{
    local num=$#
    if [ $((${num}%2)) -eq 1 ]
    then
        num=$((${num}/2+1))
    else
        num=$((${num}/2))
    fi
    local count=1
    for((i=1;i<=${num};i++))
    do
        [[ ${1#-} == "input" ]] && { INPUTPATH=$2;shift 2;check_param "${INPUTPATH}" || return 1; continue; }
    done
    return 0
}

function check_input()
{
    init_params "$@"
    if [ $? -ne 0 ]
    then
        log "Example: bash cert shellName -input paramFile path"
        return 1
    fi
}

# 获取租户名称
function get_productname()
{
    PRODUCTNAME=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['productname'])" 2>/dev/null)
    if [ -z "${PRODUCTNAME}" ]
    then
        log "ERROR: Productname is null."
        return 1
    fi
}

# 获取所有节点ip
function get_all_nodes_ip()
{
    . /opt/oss/manager/bin/engr_profile.sh
    nodes_ip=$(python <<EOF
import os
import json

nodelist_file=os.path.join(os.getenv("INSTALL_ROOT", "/opt/oss"), "manager", "etc", "sysconf", "nodelists.json")
with open(nodelist_file) as f:
    data=json.load(f)

nodes_ip_list = []
for _, node in data['nodeList'].items():
    for ip_info in node['IPAddresses']:
        if 'maintenance' in ip_info['usage']:
            nodes_ip_list.append(ip_info['IP'])
            break

nodes_ip_str = " ".join(nodes_ip_list)
print(nodes_ip_str)
EOF
)
}

function exec_sudo_cmd()
{
    get_all_nodes_ip
    log ${nodes_ip}
    log "nodes list is ${nodes_ip}"
    log ${PRODUCTNAME}
    for nodeip in ${nodes_ip}
    do
        ssh -o StrictHostKeyChecking=no ossadm@${nodeip} "if [ /opt/oss/${PRODUCTNAME}/etc/ssl/er/server_key_crypto.pem ]; then sudo -u ossuser rm -f /opt/oss/${PRODUCTNAME}/etc/ssl/er/server_key_crypto.pem; fi"
        if [ $? -eq 0 ]
        then
            log "tenant path execute delete cert file on node ${nodeip} success."
        else
            log "tenant path execute delete cert file on node ${nodeip} failed."
            return 1
        fi

        ssh -o StrictHostKeyChecking=no ossadm@${nodeip} "if [ /opt/oss/manager/etc/ssl/er/server_key_crypto.pem ]; then rm -f /opt/oss/manager/etc/ssl/er/server_key_crypto.pem; fi"
        if [ $? -eq 0 ]
        then
            log "manager path execute delete cert file on node ${nodeip} success."
        else
            log "manager path execute delete cert file on node ${nodeip} failed."
            return 1
        fi
    done
    return 0
}

function scp_file() {
    local node_ip=$1
    log "start scp file,node ip: ${node_ip}"
    log "INPUT_PATH is ${INPUTPATH}"
    scp -o StrictHostKeyChecking=no ${INPUTPATH}/plandata.json [${node_ip}]:/home/ossadm/plandata_${PRODUCTNAME}.json
    local res=$?
    if [ ${res} -eq 0 ]
        then
            log "scp plandata.json to ${node_ip} success."
        else
            log "scp plandata.json to ${node_ip} failed."
            return 1
        fi
    log "scp result is ${res}"
}

function do_scp() {
    if [ -z "${nodes_ip}" ]; then
        log "node list is null, node is:${nodes_ip}"
        return 1
    fi
    for nodeip in ${nodes_ip}
    do
        scp_file ${nodeip} || return 1
    done
    log "end scp file"
}

function main()
{
    check_input "$@" || return 1
    get_productname || return 1
    exec_sudo_cmd || return 1
    # plandata.json文件移动到业务节点
    log "start scp file"
    log "PRODUCTNAME is ${PRODUCTNAME}"
    do_scp || return 1
    log "end scp file"
}

main "$@"
exit $?
