#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# -*- coding: utf-8 -*-
"""
功 能：仲裁节点检查
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2022-5-18 12:00 创建
"""
import os
from .common_utils.check_task import OSCheckTask, OSCheckConfig

_config_params = {
    # 检查项名称
    "task_name": 'task_check_arbitration_node_sopuser_and_opt',
    # 当前目录
    "upload_src_path": os.path.split(os.path.realpath(__file__))[0],
    # 上传目录
    "upload_trg_path": f"/opt/oss/tmp",
}


def execute_task_check(kvs):
    """
    执行检查任务
    :param kvs: 全局字典
    :return: bool 检查项是否通过
    """
    script_check_opt_space = "check_opt_space.sh"
    script_check_sopuser_passwd = "check_sopuser_passwd.sh"
    task = OSCheckTask(OSCheckConfig(_config_params), kvs)
    # 只检查仲裁节点，屏蔽主备站点
    task.mask_sites(['master', 'standby'])
    # 判断是否升级勾选OS升级，只有升级OS的情况下才需要对opt空间做检查
    if task.check_kvs_contain('id_upgrade_os', 'upgrade_item'):
        if not task.upload_and_execute_script(script_check_opt_space):
            return False
    # 检查sopuser密码有效性
    if not task.upload_and_execute_script(script_check_sopuser_passwd):
        return False
    # 清理上传脚本
    if not task.rm_remote_files([script_check_opt_space, script_check_sopuser_passwd]):
        return False
    task.finish()
    return True


def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: bool 是否需要执行
    """
    # 只有升级勾选了仲裁节点才做检查
    return "id_upgrade_arbitration" in kvs.get("upgrade_item")


def exe(kvs):
    """
    功能描述：任务执行入口
    :param kvs: 全局字典
    :return: list 检查结果
    """
    return [[('', '', execute_task_check(kvs))]]
