#!/bin/bash
WORKFORDER=$(dirname $(readlink -f $0))
LOG_FILE="/var/log/check_euleros_version.log"

##############################################################################
# Description：检查并为dbuser用户创建python3软链接
##############################################################################
function create_python3_soft_link(){
    echo "Start execute create_python3_soft_link()" &>> "${LOG_FILE}"
    which python3 &>> /dev/null
    if [ $? -ne 0 ];then
        echo "python3 not exist" &>> "${LOG_FILE}"
        echo "start to create python soft link" &>> "${LOG_FILE}"
        local python3_path="/opt/oss/manager/agent/DeployAgent/rtsp/python/bin/python"
        local dbuser_bin_path="/home/dbuser/bin"
        local python3_soft_link="${dbuser_bin_path}/python3"
        local dbuser_bashrc="/home/dbuser/.bashrc"
        [ -d "${dbuser_bin_path}" ] || su - dbuser -c "mkdir ${dbuser_bin_path}" || return 1
        [ -s "${python3_soft_link}" ] || su - dbuser -c "ln -s ${python3_path} ${python3_soft_link}" || return 1
        grep "export PATH=\$PATH:/home/dbuser/bin" ${dbuser_bashrc} &>> /dev/null
        if [ $? -ne 0 ];then
            su - dbuser -c "echo \"export PATH=\\\$PATH:/home/dbuser/bin\" >> ${dbuser_bashrc}" || return 1
        fi
    fi
    return 0
}

##############################################################################
# Description：main
##############################################################################
function main(){
    create_python3_soft_link || return 1
}
main
exit $?