#!/bin/bash
##############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: check_opt_space.sh
# Description: 检查opt空间
##############################################################################

#########################
# Description: 程序主入口
#########################
function check_opt_space() {
    cat /proc/version | grep euleros &>> /dev/null
    if [ $? -ne 0 ]; then
        log "INFO" "Non-EulerOS, the opt space does not need to be checked."
        return 0
    fi
    # 跨R版本升级才检查opt空间
    uname -r | grep -i eulerosv2r11 &>> /dev/null
    if [ $? -eq 0 ]; then
        log "INFO" "Upgrade OS within the B version, do not need to check the /opt space."
        return 0
    fi
    local opt_avail_space=""
    lsblk | grep '/opt' &>> /dev/null
    if [ $? -eq 0 ]; then
        opt_avail_space=$(df -m /opt/ | tail -1 | awk -F ' ' '{print $4}')
    else
        opt_avail_space=$(df -m /| tail -1 | awk -F ' ' '{print $4}')
    fi
    # /opt空间小于4G，升级OS必定失败，报问题，保险起见，阈值设置为6G
    # shell存在小数比较
    if [ $(echo "${opt_avail_space} < 6*1024"|bc) -eq 1 ]; then
        log "ERROR" "The arbitration node /opt space is ${opt_avail_space}M, which is less than 6*1024 M. The OS upgrade will failed."
        return 1
    else
        log "INFO" "/opt space is ok, opt_avail_space=${opt_avail_space}M"
    fi
};

#########################
# Description: 日志方法
#########################
function log() {
    log_type=$1
    mes=$2
    echo "$(date '+%Y-%m-%d %H:%M:%S') $log_type $mes"
}

check_opt_space
exit $?