#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# -*- coding: utf-8 -*-
"""检查os补丁包一致性"""
from .common_utils.check_task import OSCheckTask, OSCheckConfig

_config_params = {
    # 检查项名称
    "task_name": 'task_check_os_package_upgrade',
}


def execute_task_check(kvs):
    """
    执行检查任务
    :param kvs: 全局字典
    :return: None
    """
    task = OSCheckTask(OSCheckConfig(_config_params), kvs)
    if not task.check_os_patch_consistence():
        return False
    task.finish()
    return True


def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: bool 是否需要执行
    """
    is_upgrade_os = 'id_upgrade_os' in kvs.get('upgrade_item', None)
    is_supported_os = kvs.get('os_type') in ("Euler", "Suse")
    return is_upgrade_os and is_supported_os


def exe(kvs):
    """
    功能描述：任务执行入口
    :param kvs: 全局字典
    :return: bool 检查结果
    """
    return [[('', '', execute_task_check(kvs))]]
