# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# -*- coding: utf-8 -*-
"""
检查项函数装饰器
"""
import logging
import traceback
from utils.thread_util import MultiThreadPool
from .check_exception import CheckException

_local_logger = logging.getLogger(__name__)
_local_ip = "127.0.0.1"


def decorator_multithread(func):
    """
    多线程函数装饰器。
    注意：由于该装饰器将函数的处理对象从单节点变为多节点，故装饰后函数传参会发生变化！

    被装饰函数参数要求：
    node: 执行命令时所在节点Node对象
    ip: 执行命令目标ip
    *args: 其他参数
    **kwargs: 其他关键字参数

    被装饰后函数传参改为：
    nodes_info: 所有节点Node对象字典
    *args: 其他参数
    **kwargs: 其他关键字参数
    """

    def wrapper(nodes_info, *args, **kwargs):
        thread_pool = MultiThreadPool()
        for _, node in nodes_info.items():
            if not node or not node.login_ip:
                continue
            # 为本节点任务添加任务
            thread_pool.add_thread(func, node, _local_ip, *args, **kwargs)
            # 为其他节点添加任务
            for ip in node.ip_list:
                thread_pool.add_thread(func, node, ip, *args, **kwargs)
        return thread_pool.execute_with_result()

    return wrapper


